<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::table('dishes', function (Blueprint $table) {
            if (!Schema::hasColumn('dishes', 'stock')) {
                $table->integer('stock')->default(0)->after('price');
            }
        });
        // Normalize stored image paths: remove leading 'storage/' if present
        try {
            DB::table('dishes')->where('image', 'like', 'storage/%')->orderBy('id')->chunkById(200, function($rows){
                foreach ($rows as $row) {
                    $new = substr($row->image, 8); // remove 'storage/'
                    DB::table('dishes')->where('id', $row->id)->update(['image' => $new]);
                }
            });
        } catch (\Throwable $e) {
            // ignore if table/column missing during initial setup
        }
        // Inventory movements table (for future auditing)
        if (!Schema::hasTable('inventory_movements')) {
            Schema::create('inventory_movements', function (Blueprint $table) {
                $table->id();
                $table->foreignId('dish_id')->constrained('dishes')->cascadeOnDelete();
                $table->integer('change'); // positive for addition, negative for deduction
                $table->string('reason')->nullable();
                $table->foreignId('order_id')->nullable()->constrained('orders')->nullOnDelete();
                $table->foreignId('user_id')->nullable()->constrained('users')->nullOnDelete();
                $table->text('note')->nullable();
                $table->timestamps();
            });
        }
    }

    public function down(): void
    {
        if (Schema::hasTable('inventory_movements')) {
            Schema::dropIfExists('inventory_movements');
        }
        Schema::table('dishes', function (Blueprint $table) {
            if (Schema::hasColumn('dishes', 'stock')) {
                $table->dropColumn('stock');
            }
        });
    }
};
