<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('customer_addresses', function (Blueprint $table) {
            $table->id();
            $table->foreignId('user_id')->nullable()->constrained()->nullOnDelete();
            $table->string('label')->nullable();
            $table->text('raw_address');
            $table->text('formatted_address')->nullable();
            $table->string('address_hash', 64); // sha1 or future hash
            $table->decimal('latitude', 10, 7)->nullable();
            $table->decimal('longitude', 10, 7)->nullable();
            $table->unsignedInteger('times_used')->default(0);
            $table->timestamp('last_used_at')->nullable();
            $table->boolean('is_primary')->default(false);
            $table->softDeletes();
            $table->timestamps();
            $table->index('user_id');
            $table->unique(['user_id','address_hash']);
        });

        Schema::table('orders', function (Blueprint $table) {
            if (!Schema::hasColumn('orders','customer_address_id')) {
                $table->foreignId('customer_address_id')->nullable()->after('stay_id')->constrained('customer_addresses')->nullOnDelete();
            }
        });
    }

    public function down(): void
    {
        Schema::table('orders', function (Blueprint $table) {
            if (Schema::hasColumn('orders','customer_address_id')) {
                $table->dropConstrainedForeignId('customer_address_id');
            }
        });
        Schema::dropIfExists('customer_addresses');
    }
};
