<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        // Normalize: for room deliveries with null delivery_address but room indicators, set canonical value.
        // Only reference columns that actually exist (guards for earlier schema variants)
        $hasGuest = Schema::hasColumn('orders','guest_room_number');
        $hasRoom  = Schema::hasColumn('orders','room_number');
        if (! $hasGuest && ! $hasRoom) {
            return; // nothing to normalize
        }

        $query = DB::table('orders')
            ->where('delivery_mode','room')
            ->whereNull('delivery_address')
            ->orderBy('id');

        $query->where(function($q) use ($hasGuest,$hasRoom) {
            if ($hasGuest) {
                $q->whereNotNull('guest_room_number');
            }
            if ($hasRoom) {
                // If both exist combine with OR
                if ($hasGuest) {
                    $q->orWhereNotNull('room_number');
                } else {
                    $q->whereNotNull('room_number');
                }
            }
        })->chunkById(500, function($orders) use ($hasRoom) {
            foreach ($orders as $o) {
                $room = $o->guest_room_number ?? ($hasRoom ? $o->room_number : null);
                if ($room) {
                    DB::table('orders')->where('id',$o->id)->update(['delivery_address' => 'Room '.$room]);
                }
            }
        });
    }
    public function down(): void
    {
        // No down action — data normalization.
    }
};
