<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        if (Schema::hasTable('orders')) {
            Schema::table('orders', function (Blueprint $table) {
                $table->index(['user_id'], 'orders_user_id_index');
                $table->index(['status'], 'orders_status_index');
                if (Schema::hasColumn('orders','state')) {
                    $table->index(['state'], 'orders_state_index');
                    $table->index(['delivery_mode','state','created_at'], 'orders_mode_state_created_index');
                }
            });
        }
        if (Schema::hasTable('order_items')) {
            Schema::table('order_items', function (Blueprint $table) {
                $table->index(['order_id'], 'order_items_order_id_index');
                $table->index(['dish_id'], 'order_items_dish_id_index');
            });
        }
        if (Schema::hasTable('customer_addresses')) {
            Schema::table('customer_addresses', function (Blueprint $table) {
                $table->index(['user_id','last_used_at'], 'customer_addresses_user_last_used_index');
            });
        }
        if (Schema::hasTable('inventory_movements')) {
            Schema::table('inventory_movements', function (Blueprint $table) {
                $table->index(['dish_id','created_at'], 'inventory_movements_dish_created_index');
            });
        }
    }

    public function down(): void
    {
        if (Schema::hasTable('orders')) {
            Schema::table('orders', function (Blueprint $table) {
                foreach (['orders_user_id_index','orders_status_index','orders_state_index','orders_mode_state_created_index'] as $idx) {
                    $this->dropIndexIfExists('orders', $idx);
                }
            });
        }
        if (Schema::hasTable('order_items')) {
            Schema::table('order_items', function (Blueprint $table) {
                foreach (['order_items_order_id_index','order_items_dish_id_index'] as $idx) {
                    $this->dropIndexIfExists('order_items', $idx);
                }
            });
        }
        if (Schema::hasTable('customer_addresses')) {
            Schema::table('customer_addresses', function (Blueprint $table) {
                $this->dropIndexIfExists('customer_addresses','customer_addresses_user_last_used_index');
            });
        }
        if (Schema::hasTable('inventory_movements')) {
            Schema::table('inventory_movements', function (Blueprint $table) {
                $this->dropIndexIfExists('inventory_movements','inventory_movements_dish_created_index');
            });
        }
    }

    // (Helper methods removed: simplified migration avoids DBAL dependency.)
};
