<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('inventory_movements', function (Blueprint $table) {
            // Index for filtering by dish
            $table->index('dish_id', 'idx_inventory_movements_dish_id');
            
            // Index for filtering by reason
            $table->index('reason', 'idx_inventory_movements_reason');
            
            // Index for filtering by user
            $table->index('user_id', 'idx_inventory_movements_user_id');
            
            // Index for filtering by order
            $table->index('order_id', 'idx_inventory_movements_order_id');
            
            // Composite index for date range queries (most common filter)
            $table->index('created_at', 'idx_inventory_movements_created_at');
            
            // Composite index for dish + date (common combination)
            $table->index(['dish_id', 'created_at'], 'idx_inventory_movements_dish_date');
            
            // Composite index for reason + date (for sales analysis)
            $table->index(['reason', 'created_at'], 'idx_inventory_movements_reason_date');
        });
        
        Schema::table('dishes', function (Blueprint $table) {
            // Index for low stock queries
            $table->index(['stock', 'low_stock_threshold'], 'idx_dishes_stock_threshold');
            
            // Index for category filtering
            $table->index('category_id', 'idx_dishes_category_id');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('inventory_movements', function (Blueprint $table) {
            $table->dropIndex('idx_inventory_movements_dish_id');
            $table->dropIndex('idx_inventory_movements_reason');
            $table->dropIndex('idx_inventory_movements_user_id');
            $table->dropIndex('idx_inventory_movements_order_id');
            $table->dropIndex('idx_inventory_movements_created_at');
            $table->dropIndex('idx_inventory_movements_dish_date');
            $table->dropIndex('idx_inventory_movements_reason_date');
        });
        
        Schema::table('dishes', function (Blueprint $table) {
            $table->dropIndex('idx_dishes_stock_threshold');
            $table->dropIndex('idx_dishes_category_id');
        });
    }
};
