<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('dishes', function (Blueprint $table) {
            // Velocity tracking
            $table->decimal('velocity_7d', 8, 2)->default(0)->after('low_stock_threshold')->comment('7-day average units sold per day');
            $table->decimal('velocity_30d', 8, 2)->default(0)->after('velocity_7d')->comment('30-day average units sold per day');
            
            // Safety stock and reorder management
            $table->integer('safety_stock')->default(0)->after('velocity_30d')->comment('Minimum safety stock level');
            $table->integer('reorder_point')->default(0)->after('safety_stock')->comment('Stock level to trigger reorder');
            
            // Forecasting metrics
            $table->decimal('projected_runway_days', 8, 1)->nullable()->after('reorder_point')->comment('Projected days until stockout based on velocity');
            $table->timestamp('velocity_updated_at')->nullable()->after('projected_runway_days')->comment('Last velocity calculation timestamp');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('dishes', function (Blueprint $table) {
            $table->dropColumn([
                'velocity_7d',
                'velocity_30d',
                'safety_stock',
                'reorder_point',
                'projected_runway_days',
                'velocity_updated_at'
            ]);
        });
    }
};
