<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('inventory_alerts', function (Blueprint $table) {
            $table->id();
            $table->foreignId('dish_id')->constrained('dishes')->cascadeOnDelete();
            $table->enum('type', ['low_stock', 'out_of_stock', 'projected_stockout', 'safety_stock_breach'])->comment('Type of alert');
            $table->enum('severity', ['low', 'medium', 'high', 'critical'])->default('medium')->comment('Alert severity level');
            $table->enum('status', ['active', 'acknowledged', 'dismissed', 'resolved'])->default('active')->comment('Alert status');
            
            // Alert details
            $table->string('title', 255)->comment('Alert title');
            $table->text('message')->comment('Alert description');
            $table->json('metadata')->nullable()->comment('Additional alert data (current stock, velocity, etc.)');
            
            // Projected information
            $table->decimal('projected_stockout_days', 8, 1)->nullable()->comment('Days until projected stockout');
            $table->integer('current_stock')->comment('Stock level when alert was generated');
            $table->decimal('current_velocity', 8, 2)->nullable()->comment('Velocity when alert was generated');
            
            // Alert management
            $table->foreignId('acknowledged_by')->nullable()->constrained('users')->nullOnDelete();
            $table->timestamp('acknowledged_at')->nullable();
            $table->text('acknowledgment_note')->nullable();
            
            $table->timestamps();
            
            // Indexes for performance
            $table->index(['dish_id', 'type', 'status']);
            $table->index(['status', 'severity']);
            $table->index('created_at');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('inventory_alerts');
    }
};
