<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        if (Schema::hasTable('inventory_movements')) {
            Schema::table('inventory_movements', function (Blueprint $table) {
                if (!Schema::hasColumn('inventory_movements', 'location_id')) {
                    $table->foreignId('location_id')->nullable()->after('dish_id')->constrained('locations')->nullOnDelete();
                }
                if (!Schema::hasColumn('inventory_movements', 'transfer_group')) {
                    $table->string('transfer_group')->nullable()->after('reason')->index();
                }
            });
        }
    }

    public function down(): void
    {
        if (Schema::hasTable('inventory_movements')) {
            Schema::table('inventory_movements', function (Blueprint $table) {
                if (Schema::hasColumn('inventory_movements', 'location_id')) {
                    $table->dropConstrainedForeignId('location_id');
                }
                if (Schema::hasColumn('inventory_movements', 'transfer_group')) {
                    $table->dropIndex(['transfer_group']);
                    $table->dropColumn('transfer_group');
                }
            });
        }
    }
};
