<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::table('inventory_stats', function (Blueprint $table) {
            // Drop lingering unique constraint on dish_id if present
            try {
                $table->dropUnique('inventory_stats_dish_id_unique');
            } catch (\Throwable $e) {
                // Fallback: try by column signature (Laravel will infer name)
                try {
                    $table->dropUnique(['dish_id']);
                } catch (\Throwable $e2) {
                    // ignore if not exists
                }
            }
        });

        // Ensure composite unique (dish_id, location_id) exists
        try {
            DB::statement('CREATE UNIQUE INDEX `inventory_stats_dish_location_unique` ON `inventory_stats` (`dish_id`, `location_id`)');
        } catch (\Throwable $e) {
            // ignore if already exists
        }
    }

    public function down(): void
    {
        // Drop composite unique
        try {
            DB::statement('ALTER TABLE `inventory_stats` DROP INDEX `inventory_stats_dish_location_unique`');
        } catch (\Throwable $e) {
            // ignore
        }

        // Restore single-column unique on dish_id
        try {
            DB::statement('CREATE UNIQUE INDEX `inventory_stats_dish_id_unique` ON `inventory_stats` (`dish_id`)');
        } catch (\Throwable $e) {
            // ignore
        }
    }
};
