<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\User;
use App\Models\Order;
use App\Models\Dish;
use App\Models\OrderItem;
use App\Models\Category;
use App\Models\CustomerAddress;
use Spatie\Permission\Models\Role;
use Illuminate\Support\Facades\Hash;

class DashboardTestDataSeeder extends Seeder
{
    public function run()
    {
        // Create test customer user if not exists
        $customer = User::firstOrCreate(
            ['email' => 'customer@test.com'],
            [
                'name' => 'John Customer',
                'phone' => '+234 801 234 5678',
                'password' => Hash::make('password'),
                'email_verified_at' => now(),
            ]
        );

        // Ensure we have some categories
        $category = Category::firstOrCreate(
            ['name' => 'Nigerian Classics'],
            []
        );

        // Create some test dishes if they don't exist
        $dishes = [];
        $dishesData = [
            ['name' => 'Jollof Rice', 'price' => 2500, 'description' => 'Spicy rice dish'],
            ['name' => 'Egusi Soup', 'price' => 3000, 'description' => 'Melon seed soup'],
            ['name' => 'Suya', 'price' => 1500, 'description' => 'Grilled meat skewers'],
            ['name' => 'Pepper Soup', 'price' => 2000, 'description' => 'Spicy soup'],
        ];

        foreach ($dishesData as $dishData) {
            $dishes[] = Dish::firstOrCreate(
                ['name' => $dishData['name']],
                [
                    'price' => $dishData['price'],
                    'description' => $dishData['description'],
                    'category_id' => $category->id,
                ]
            );
        }

        // Create customer address
        CustomerAddress::firstOrCreate(
            [
                'user_id' => $customer->id,
                'label' => 'Home'
            ],
            [
                'full_address' => '123 Lagos Street, Victoria Island, Lagos',
                'is_primary' => true,
            ]
        );

        // Create some test orders for the customer
        $statuses = ['Delivered', 'In Kitchen', 'Ready', 'Out for Delivery'];
        
        for ($i = 0; $i < 5; $i++) {
            $order = Order::create([
                'user_id' => $customer->id,
                'subtotal' => rand(2000, 8000),
                'total' => rand(2200, 8500),
                'status' => $statuses[array_rand($statuses)],
                'delivery_mode' => 'delivery',
                'payment_method' => 'paystack',
                'created_at' => now()->subDays(rand(0, 30)),
            ]);

            // Add order items
            $numItems = rand(1, 3);
            for ($j = 0; $j < $numItems; $j++) {
                $dish = $dishes[array_rand($dishes)];
                OrderItem::create([
                    'order_id' => $order->id,
                    'dish_id' => $dish->id,
                    'quantity' => rand(1, 2),
                    'unit_price' => $dish->price,
                ]);
            }
        }

        $this->command->info('Dashboard test data created successfully!');
    }
}