<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Dish;
use App\Models\Category;

class DishSeeder extends Seeder
{
    public function run(): void
    {
        // Map category names to IDs (ensures CategorySeeder ran)
        $cat = Category::pluck('id','name');

        $dishes = [
            [ 'category' => 'Soups & Swallows', 'name' => 'Egusi Soup with Pounded Yam', 'description' => 'Rich melon seed soup cooked with leafy vegetables and assorted meats, served with freshly pounded yam.', 'price' => 4000, 'image' => 'assets/images/egusi.jpg', 'vegetarian' => false, 'halal' => true, 'gluten_free' => false ],
            [ 'category' => 'Rice Dishes', 'name' => 'Jollof Rice with Grilled Chicken', 'description' => 'Classic smoky Nigerian jollof rice served with succulent grilled chicken and side salad.', 'price' => 3500, 'image' => 'assets/images/jollof.jpg', 'vegetarian' => false, 'halal' => true, 'gluten_free' => true ],
            [ 'category' => 'Soups & Swallows', 'name' => 'Pepper Soup', 'description' => 'Light broth spiced with West African seasonings and choice of fish or goat meat.', 'price' => 2500, 'image' => 'assets/images/pepper_soup.jpg', 'vegetarian' => false, 'halal' => true, 'gluten_free' => true ],
            [ 'category' => 'Stews', 'name' => 'Efo Riro', 'description' => 'Spinach stew cooked with assorted meats, locust beans and spices.', 'price' => 3000, 'image' => 'assets/images/efo_riro.jpg', 'vegetarian' => false, 'halal' => true, 'gluten_free' => true ],
            [ 'category' => 'Grills & Proteins', 'name' => 'Suya Platter', 'description' => 'Street-style spicy grilled beef skewers garnished with onions, tomatoes and special suya spice.', 'price' => 4500, 'image' => 'assets/images/suya.jpg', 'vegetarian' => false, 'halal' => true, 'gluten_free' => true ],
            [ 'category' => 'Breakfast', 'name' => 'Akara & Pap', 'description' => 'Golden bean fritters served with sweet corn pap for a hearty breakfast.', 'price' => 1500, 'image' => 'assets/images/akara_pap.jpg', 'vegetarian' => true, 'halal' => true, 'gluten_free' => true ],
        ];

        foreach ($dishes as $d) {
            $categoryId = $cat[$d['category']] ?? null;
            if (!$categoryId) { continue; }

            Dish::firstOrCreate(
                ['name' => $d['name']],
                [
                    'category_id' => $categoryId,
                    'description' => $d['description'],
                    'price' => $d['price'],
                    'image' => $d['image'],
                    'vegetarian' => $d['vegetarian'],
                    'halal' => $d['halal'],
                    'gluten_free' => $d['gluten_free'],
                    'stock' => 50,
                ]
            );
        }
    }
}
