<?php

namespace Database\Seeders;

use App\Models\User;
use Illuminate\Database\Seeder;
use Spatie\Permission\Models\Role;

class RoleSeeder extends Seeder
{
    public function run(): void
    {
    $roles = ['Super Admin','Manager','Kitchen','Cashier','Rider','Support','Content Editor','Customer'];
        foreach ($roles as $name) {
            Role::firstOrCreate(['name' => $name]);
        }

        $admin = User::firstOrCreate(
            ['email' => 'admin@bonnydelight.ng'],
            [
                'name' => 'Admin User',
                'password' => bcrypt('ChangeMe123!'),
                'phone' => '08000000000',
                'role' => 'admin',
            ]
        );

        if (!$admin->hasRole('Super Admin')) {
            $admin->assignRole('Super Admin');
        }
    }
}
