<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Setting;

class SettingSeeder extends Seeder
{
    public function run(): void
    {
        $defaults = [
            ['key'=>'business.name','value'=>'Bonny Delight','type'=>'string','group'=>'business','description'=>'Brand name'],
            ['key'=>'business.open_hours','value'=>json_encode([
                'mon'=>['08:00','22:00'], 'tue'=>['08:00','22:00'], 'wed'=>['08:00','22:00'], 'thu'=>['08:00','22:00'], 'fri'=>['08:00','23:00'], 'sat'=>['09:00','23:00'], 'sun'=>['09:00','22:00'],
            ]),'type'=>'json','group'=>'business','description'=>'Opening hours per day'],
            ['key'=>'order.min_subtotal','value'=>'0','type'=>'decimal','group'=>'orders','description'=>'Minimum order subtotal'],
            ['key'=>'order.service_charge_percent','value'=>'0','type'=>'decimal','group'=>'orders','description'=>'Service charge %'],
            ['key'=>'delivery.fee_base','value'=>'1000','type'=>'decimal','group'=>'delivery','description'=>'Base delivery fee'],
            ['key'=>'delivery.free_threshold','value'=>'20000','type'=>'decimal','group'=>'delivery','description'=>'Free delivery threshold'],
            ['key'=>'room_service.enabled','value'=>'1','type'=>'bool','group'=>'room_service','description'=>'Enable Charge to Room'],
            ['key'=>'room_service.min_order','value'=>'0','type'=>'decimal','group'=>'room_service','description'=>'Min order for room service'],
            ['key'=>'room_service.verification_mode','value'=>'phone','type'=>'string','group'=>'room_service','description'=>'Verification mode: phone|pin|none'],
            ['key'=>'capacity.max_open_orders','value'=>'50','type'=>'int','group'=>'capacity','description'=>'Throttle new orders when open orders exceed this'],
            ['key'=>'pwa.enabled','value'=>'1','type'=>'bool','group'=>'pwa','description'=>'Enable PWA features'],
        ];

        foreach ($defaults as $row) {
            Setting::updateOrCreate(
                ['key'=>$row['key']],
                [
                    'value' => $row['value'],
                    'type' => $row['type'],
                    'group' => $row['group'],
                    'description' => $row['description'],
                    'autoload' => true,
                ]
            );
        }
    }
}
