<?php

namespace Database\Seeders;

use App\Models\User;
use Illuminate\Database\Seeder;

class TestUserSeeder extends Seeder
{
    public function run(): void
    {
        $users = [
            ['name'=>'Super Admin','email'=>'admin@bonnydelight.ng','password'=>'ChangeMe123!','roleSpatie'=>'Super Admin','roleColumn'=>'admin'],
            ['name'=>'Manager One','email'=>'manager@bonnydelight.ng','password'=>'TestPass123!','roleSpatie'=>'Manager','roleColumn'=>'admin'],
            ['name'=>'Kitchen Staff','email'=>'kitchen@bonnydelight.ng','password'=>'TestPass123!','roleSpatie'=>'Kitchen','roleColumn'=>'kitchen'],
            ['name'=>'Cashier One','email'=>'cashier@bonnydelight.ng','password'=>'TestPass123!','roleSpatie'=>'Cashier','roleColumn'=>'admin'],
            ['name'=>'Content Editor','email'=>'editor@bonnydelight.ng','password'=>'TestPass123!','roleSpatie'=>'Content Editor','roleColumn'=>'admin'],
            ['name'=>'Rider One','email'=>'rider@bonnydelight.ng','password'=>'TestPass123!','roleSpatie'=>'Rider','roleColumn'=>'rider'],
            ['name'=>'Customer Demo','email'=>'customer@bonnydelight.ng','password'=>'TestPass123!','roleSpatie'=>'Customer','roleColumn'=>'customer'],
            ['name'=>'Admin Tester','email'=>'admin.tester@bonnydelight.ng','password'=>'AdminTest123!','roleSpatie'=>'Manager','roleColumn'=>'admin'],
            ['name'=>'User Tester','email'=>'user.tester@bonnydelight.ng','password'=>'UserTest123!','roleSpatie'=>'Customer','roleColumn'=>'customer'],
        ];

        foreach ($users as $u) {
            $user = User::firstOrCreate(
                ['email' => $u['email']],
                [
                    'name' => $u['name'],
                    'password' => bcrypt($u['password']),
                    'phone' => '08000000000',
                    'role' => $u['roleColumn'],
                    'email_verified_at' => now(),
                ]
            );

            if (!empty($u['roleSpatie'])) {
                try {
                    if (!$user->hasRole($u['roleSpatie'])) {
                        $user->assignRole($u['roleSpatie']);
                    }
                } catch (\Throwable $e) {
                    // role table may not exist yet
                }
            }
        }
    }
}
