# Design System — Bonny Delight

This document captures the evolving design tokens, component primitives, and styling strategy. The goal is to keep a single source of truth and prevent drift while retaining resilience when the CSS build pipeline (Tailwind/Vite) is not running.

## Principles
- Semantic tokens first ("what" not raw hex) — usage goes through variables.
- Progressive enhancement: core pages remain styled even if Tailwind utilities are missing (fallback classes + base CSS).
- Low specificity & composable classes.
- Theming support (light/dark) via root + `.dark` overrides only.
- Avoid deep component nesting in CSS; use utility + small semantic classes.

## Token Layers
Defined in `resources/css/app.css` inside `@layer base`:

| Token Group        | Examples                                      | Notes |
|--------------------|-----------------------------------------------|-------|
| Brand Colors       | `--brand-primary`, `--brand-secondary`        | Base brand palette (RGB triplets) |
| Semantic Surfaces  | `--color-bg`, `--color-surface`, `--color-overlay` | Adjusted in `.dark` context |
| Text Colors        | `--color-text`, `--color-text-muted`          | Inverse variant for dark backgrounds |
| Feedback Status    | `--brand-success`, `--brand-danger`, etc.     | Used in badges & alerts |
| Elevations         | `--elevation-0` … `--elevation-2`             | Box shadow recipes |
| Focus Ring         | `--elevation-focus-ring`                      | Applied via `.btn:focus-visible`, inputs, etc. |

All tokens expressed as space‑separated RGB values to allow alpha channel mixing: `rgb(var(--brand-primary) / 0.15)`.

## Component Primitives (in `@layer components`)
- Buttons: `.btn`, variants `.btn-primary`, `.btn-secondary`, `.btn-outline`, `.btn-ghost`, `.btn-danger`.
- Badges: `.badge`, status badge variants (e.g. `.badge-status-in-kitchen`).
- Forms: `.form-stack`, `.form-group`, `.form-label`, `.input`, `.select`, `.textarea`.
- Layout helpers: `.container-px`, `.surface`, `.surface-alt`, `.surface-glass`.
- Cards: `.card`, `.card-glass`, `.card-muted`.
- Navigation: `.nav-pill`, `.nav-pill-active` (animated underline & active states).

## Minimal Utility Fallbacks (`@layer utilities`)
A curated subset of utility classes included manually to ensure visual continuity without a Tailwind build (Hybrid Mode): `.text-3xl`, `.flex`, `.grid`, `.gap-4`, spacing shorthands, simple width/rounded classes, color shortcuts like `.text-primary`.

## Dark Mode
Implemented with a `.dark` class on `html` or `body`. Override only the tokens. Components simply inherit new token values.

## Auth / Legacy Cleanup
Deprecated experimental classes removed: `.auth-hero`, `.auth-grid`, `.auth-display`, `.auth-benefits`, `.auth-panel*` to reduce noise.

## Responsive Images
`<x-responsive-image>` component + pre-generated variants stored in `public/assets/images/` with naming pattern `name-WIDTH.(avif|webp|jpg)` plus `-lqip` placeholder. Use the component for dishes; fallback `<img>` for simpler cases.

## Future Enhancements
- Extract tokens to `resources/css/tokens.css` + import for clarity.
- Add motion tokens (durations, easing) & elevation scale beyond level 2.
- Generate a styleguide page at `/styleguide` listing tokens & components.
- Provide design tokens JSON for potential frontend frameworks.

## Usage Guidelines
- Prefer semantic surface classes or tokens instead of hardcoded hex.
- When adding a new variant, ensure accessible contrast (WCAG AA) against surfaces.
- Do not introduce new brand colors without updating this doc.

## Change Log
- 2025-10-03: Initial documentation scaffold; removed deprecated auth hero classes; added fallback utilities explanation.
