# Inventory Risk Assessment

Date: 2025-10-17
Scope: Phase 1 (service + ledger). Future phases (allocation, BOM, forecasting) referenced where helpful.

## Risks

1) Oversell race conditions
- Multiple checkouts attempt to decrement the same dish concurrently.
- Result: Negative stock or silent drift if not guarded.

Mitigation
- Centralize all stock changes in InventoryService.
- Pessimistic row lock (lockForUpdate) around target dish.
- Non-negative enforcement: reject movement if new_stock < 0.
- Pre-checkout availability validation to fail fast.

2) Inconsistent manual adjustments
- Ad hoc stock changes bypass audit.

Mitigation
- Route all admin adjustments via InventoryService::adjust with reason validation.
- Maintain InventoryMovement ledger. Index dish_id, reason, created_at for reviewability.

3) Cancellations and refunds
- After a sale movement, order may be cancelled or refunded; stock may need to be returned.

Mitigation (Current Guidance)
- For full cancellation before fulfillment: create a reversing adjustment movement with reason 'correction' or a dedicated 'return' (if enabled), and increase stock accordingly.
- For partial refunds: mirror the returned quantity with a positive adjustment movement referencing the order.
- Ensure UI workflows constrain who can perform reversals; require note and user tracking.

4) Movement reason drift
- Inconsistent reason strings reduce reporting quality.

Mitigation
- Maintain canonical reasons list in InventoryService::MOVEMENT_REASONS and validate.
- Map any legacy values during migration; avoid free-text where possible in UI (use selects).

5) Performance degradation as ledger grows
- Movements table grows; queries (top sellers, filters) may slow down.

Mitigation
- Strategic indexes (dish_id, reason, user_id, order_id, created_at, combined).
- Consider snapshot/stat tables and periodic reconciliation in Phase 8.
- Paginate UI; avoid N+1 with with() eager loads.

6) Timezone and reporting accuracy
- Reporting windows and date filters may be ambiguous.

Mitigation
- Normalize created_at in UTC; present in local time in UI.
- Define reporting windows (daily/weekly/monthly) and stick to them.

7) Data integrity during migrations
- Partially applied schema changes could cause runtime errors.

Mitigation
- Guard with Schema::hasColumn/hasTable in controllers/views where appropriate.
- Use idempotent migrations; wrap creates with conditional checks.

## Procedures

- Reversal Procedure (admin):
  1. Identify order and movement(s) to reverse.
  2. Create positive adjustment for the return quantity.
  3. Reason: 'correction' (or 'return' if that pathway is enabled), include order_id and note.

- Stock Count Correction:
  1. Perform a physical count.
  2. Compute delta vs system stock.
  3. Apply adjustment with reason 'correction'; include note and user.

## Controls

- RBAC: restrict inventory adjustments to Manager/Super Admin.
- Logging: retain movement notes; include user_id and order_id when applicable.
- Reviews: periodic review of movements for anomalies.

## Validation

- Tests cover: insufficient stock, concurrent decrements, audit trail, checkout integration.
- Recommended: add a scheduled reconciliation job (Phase 8) to compare dish.stock with sum of movements to detect drift.
