# What if cPanel does NOT have Composer?

If your cPanel server does not have Composer, you can still deploy your Laravel app by installing dependencies locally and uploading them:

1. **Install Composer Locally**
   - On your computer, run:
     ```sh
     composer install --no-dev --optimize-autoloader
     ```
   - This will create the `vendor` folder with all required PHP packages.

2. **Zip and Upload Your Project**
   - Zip your entire project **including the `vendor` folder** (but excluding `node_modules`, `.git`, and cache files).
   - Upload and extract the zip in your cPanel project directory (e.g., `~/app.bonnydelight.ng`).

3. **Continue With Standard Steps**
   - Set up `.env` as described above.
   - Set permissions:
     ```sh
     chmod -R 755 storage bootstrap/cache
     ```
   - Link storage:
     ```sh
     php artisan storage:link
     ```
   - Run migrations:
     ```sh
     php artisan migrate --force
     ```

**Tip:**
- If you update dependencies, repeat the local `composer install` and re-upload the `vendor` folder.
- If you ever get Composer on your server, you can switch to installing dependencies directly there.

---
# Go Live Guide: Deploying to app.bonnydelight.ng

This guide will help you deploy your Laravel project to the subdomain `app.bonnydelight.ng` on cPanel hosting.

---

## 1. Prepare Your Files
- Ensure your code is up to date and tested locally.
- Run `npm run build` locally to generate production assets (if using Vite/Tailwind).
- Delete `node_modules` and `vendor` folders to reduce upload size.
- Zip your project folder (except `node_modules`, `vendor`, `.git`, and local cache files).

## 2. Upload to cPanel
- Log in to cPanel and open **File Manager**.
- Upload and extract your zipped project to a directory, e.g., `~/app.bonnydelight.ng`.

## 3. Set Document Root
- In cPanel, go to **Domains > Subdomains**.
- Set the document root for `app.bonnydelight.ng` to `~/app.bonnydelight.ng/public`.

## 4. Install Composer Dependencies
- Open **Terminal** or **SSH** in cPanel.
- Run:
  ```sh
  cd ~/app.bonnydelight.ng
  composer install --no-dev --optimize-autoloader
  ```

## 5. Configure Environment
- Rename `.env_server` to `.env`.
- Edit `.env`:
  - `APP_URL=https://app.bonnydelight.ng`
  - Set correct `DB_*` credentials (use cPanel MySQL info).
  - Set `SESSION_COOKIE=app_bonnydelight_session_v2`
  - Set `APP_KEY` (copy from local if needed).

## 6. Set Permissions
- In Terminal/SSH, run:
  ```sh
  chmod -R 755 storage bootstrap/cache
  ```

## 7. Link Storage
- Run:
  ```sh
  php artisan storage:link
  ```

## 8. Run Migrations
- Run:
  ```sh
  php artisan migrate --force
  ```

## 9. Upload Production Assets
- If you built assets locally, upload the contents of `public/build` and `public/assets` to the server.

## 10. Set Up Scheduler (Optional)
- In cPanel, go to **Cron Jobs** and add:
  ```sh
  * * * * * php /home/yourcpaneluser/app.bonnydelight.ng/artisan schedule:run >> /dev/null 2>&1
  ```

## 11. Clear and Cache Config
- Run:
  ```sh
  php artisan config:cache
  php artisan route:cache
  php artisan view:cache
  ```

## 12. Test Your App
- Visit https://app.bonnydelight.ng in your browser.
- Test login, ordering, PWA install, and QR codes.

---

### Troubleshooting
- **White screen?** Check `storage/logs/laravel.log` for errors.
- **Permission errors?** Re-run the permissions step.
- **.env not loading?** Ensure the file is named `.env` and in the project root.

---

**You're live!**

For help, contact your developer or server support.