<?php
/**
 * Standalone QR Code Generator for Apache setup
 * Generates modern QR codes with logo overlay
 */

// Get parameters
$size = isset($_GET['size']) ? max(100, min(500, (int)$_GET['size'])) : 200;
$type = isset($_GET['type']) ? $_GET['type'] : 'pwa';

// Base URL for your site
$baseUrl = 'http://localhost:9090/bonny_delight/public';

// Generate QR data based on type
switch ($type) {
    case 'pwa':
        $qrData = $baseUrl;
        break;
    case 'contact':
        $qrData = $baseUrl . '/contact';
        break;
    default:
        $qrData = $baseUrl;
        break;
}

// Set content type to SVG
header('Content-Type: image/svg+xml');
header('Cache-Control: public, max-age=3600');

// QR Code configuration
$qrSize = $size;
$logoSize = (int)($qrSize * 0.15); // Logo is 15% of QR size
$logoOffset = (int)(($qrSize - $logoSize) / 2);

// Calculate positions for SVG
$logoCenter = $logoSize / 2;
$logoRadius = $logoSize / 2;
$logoRadiusWithPadding = $logoRadius + 3;
$logoFontSize = $logoSize / 3;

// Calculate QR area dimensions
$qrAreaSize = $qrSize - 40;

// Create a simple QR pattern (basic grid pattern for demo)
$gridSize = 21; // Standard QR code grid
$cellSize = $qrAreaSize / $gridSize; // Account for padding
$qrPattern = '';

// Generate a basic QR-like pattern
for ($row = 0; $row < $gridSize; $row++) {
    for ($col = 0; $col < $gridSize; $col++) {
        // Create finder patterns at corners
        $isFinderPattern = false;
        
        // Top-left finder pattern
        if (($row < 7 && $col < 7) || 
            // Top-right finder pattern  
            ($row < 7 && $col >= $gridSize - 7) ||
            // Bottom-left finder pattern
            ($row >= $gridSize - 7 && $col < 7)) {
            $isFinderPattern = true;
        }
        
        // Create pattern based on data
        $hash = crc32($qrData . $row . $col);
        $shouldFill = ($hash % 2 === 0) || $isFinderPattern;
        
        if ($shouldFill) {
            $x = 20 + ($col * $cellSize);
            $y = 20 + ($row * $cellSize);
            $qrPattern .= "<rect x=\"{$x}\" y=\"{$y}\" width=\"{$cellSize}\" height=\"{$cellSize}\" fill=\"#1f2937\"/>\n    ";
        }
    }
}

// Create modern SVG with embedded QR and logo
$svg = <<<SVG
<svg width="{$qrSize}" height="{$qrSize}" viewBox="0 0 {$qrSize} {$qrSize}" xmlns="http://www.w3.org/2000/svg">
  <defs>
    <linearGradient id="bgGradient" x1="0%" y1="0%" x2="100%" y2="100%">
      <stop offset="0%" style="stop-color:#ffffff;stop-opacity:1" />
      <stop offset="100%" style="stop-color:#f1f5f9;stop-opacity:1" />
    </linearGradient>
    <linearGradient id="logoGradient" x1="0%" y1="0%" x2="100%" y2="100%">
      <stop offset="0%" style="stop-color:#10b981;stop-opacity:1" />
      <stop offset="100%" style="stop-color:#059669;stop-opacity:1" />
    </linearGradient>
    <filter id="shadow" x="-50%" y="-50%" width="200%" height="200%">
      <feDropShadow dx="0" dy="2" stdDeviation="4" flood-color="#000000" flood-opacity="0.25"/>
    </filter>
  </defs>
  
  <!-- Background -->
  <rect width="{$qrSize}" height="{$qrSize}" fill="url(#bgGradient)" rx="16" ry="16"/>
  
  <!-- QR Code Pattern -->
  <g>
    <!-- White background for QR area -->
    <rect x="20" y="20" width="{$qrAreaSize}" height="{$qrAreaSize}" fill="white" rx="8" ry="8"/>
    <!-- QR Pattern -->
    {$qrPattern}
  </g>
  
  <!-- Logo overlay -->
  <g transform="translate({$logoOffset}, {$logoOffset})">
    <!-- Logo background circle with shadow -->
    <circle cx="{$logoCenter}" cy="{$logoCenter}" r="{$logoRadiusWithPadding}" fill="white" filter="url(#shadow)"/>
    <!-- Logo circle -->
    <circle cx="{$logoCenter}" cy="{$logoCenter}" r="{$logoRadius}" fill="url(#logoGradient)"/>
    <!-- Logo text -->
    <text x="50%" y="50%" text-anchor="middle" dy="0.35em" font-family="Arial, sans-serif" font-size="{$logoFontSize}" fill="white" font-weight="bold">
      BD
    </text>
  </g>
</svg>
SVG;

echo $svg;
?>