<?php
/**
 * Standalone QR Code Generator for Apache setup
 * Generates modern QR codes with logo overlay
 */

// Get parameters
$size = isset($_GET['size']) ? max(100, min(500, (int)$_GET['size'])) : 200;
$type = isset($_GET['type']) ? $_GET['type'] : 'pwa';

// Base URL for your site
$baseUrl = 'http://localhost:9090/bonny_delight/public';

// Generate QR data based on type
switch ($type) {
    case 'pwa':
        $qrData = $baseUrl;
        break;
    case 'contact':
        $qrData = $baseUrl . '/contact';
        break;
    default:
        $qrData = $baseUrl;
        break;
}

// Set content type to SVG
header('Content-Type: image/svg+xml');
header('Cache-Control: public, max-age=3600');

# QR Code configuration
$qrSize = $size;
$logoSize = (int)($qrSize * 0.15); // Logo is 15% of QR size
$logoOffset = (int)(($qrSize - $logoSize) / 2);

# Calculate positions for SVG
$logoCenter = $logoSize / 2;
$logoRadius = $logoSize / 2;
$logoRadiusWithPadding = $logoRadius + 3;
$logoFontSize = $logoSize / 3;

// For now, we'll use a placeholder that fetches from QR server and overlays logo
// In production, you'd want to use a proper QR library
$qrCodeDataUrl = 'https://api.qrserver.com/v1/create-qr-code/?size=' . ($qrSize-20) . 'x' . ($qrSize-20) . '&data=' . urlencode($qrData) . '&format=svg&bgcolor=ffffff&color=1f2937';

// Fetch the QR code SVG
$qrSvgContent = @file_get_contents($qrCodeDataUrl);

if ($qrSvgContent) {
    // Parse and modify the QR SVG to add our logo
    $qrSvgContent = str_replace('<?xml version="1.0" encoding="UTF-8"?>', '', $qrSvgContent);
    $qrSvgContent = str_replace('<svg', '<g transform="translate(10, 10)"><svg', $qrSvgContent);
    $qrSvgContent = str_replace('</svg>', '</svg></g>', $qrSvgContent);
}

// Create modern SVG with embedded QR and logo
$svg = <<<SVG
<svg width="{$qrSize}" height="{$qrSize}" viewBox="0 0 {$qrSize} {$qrSize}" xmlns="http://www.w3.org/2000/svg">
  <defs>
    <linearGradient id="bgGradient" x1="0%" y1="0%" x2="100%" y2="100%">
      <stop offset="0%" style="stop-color:#ffffff;stop-opacity:1" />
      <stop offset="100%" style="stop-color:#f1f5f9;stop-opacity:1" />
    </linearGradient>
    <linearGradient id="logoGradient" x1="0%" y1="0%" x2="100%" y2="100%">
      <stop offset="0%" style="stop-color:#10b981;stop-opacity:1" />
      <stop offset="100%" style="stop-color:#059669;stop-opacity:1" />
    </linearGradient>
    <filter id="shadow" x="-50%" y="-50%" width="200%" height="200%">
      <feDropShadow dx="0" dy="2" stdDeviation="4" flood-color="#000000" flood-opacity="0.25"/>
    </filter>
  </defs>
  
  <!-- Background -->
  <rect width="{$qrSize}" height="{$qrSize}" fill="url(#bgGradient)" rx="16" ry="16"/>
  
  <!-- QR Code -->
  {$qrSvgContent}
  
  <!-- Logo overlay -->
  <g transform="translate({$logoOffset}, {$logoOffset})">
    <!-- Logo background circle with shadow -->
    <circle cx="{$logoCenter}" cy="{$logoCenter}" r="{$logoRadiusWithPadding}" fill="white" filter="url(#shadow)"/>
    <!-- Logo circle -->
    <circle cx="{$logoCenter}" cy="{$logoCenter}" r="{$logoRadius}" fill="url(#logoGradient)"/>
    <!-- Logo text -->
    <text x="50%" y="50%" text-anchor="middle" dy="0.35em" font-family="Arial, sans-serif" font-size="{$logoFontSize}" fill="white" font-weight="bold">
      BD
    </text>
  </g>
</svg>
SVG;

echo $svg;