const VERSION = 'v4';
const STATIC_CACHE = `bonny-static-${VERSION}`;
const OFFLINE_URL = '/offline.html';

self.addEventListener('install', (event) => {
  self.skipWaiting();
  event.waitUntil((async () => {
    const cache = await caches.open(STATIC_CACHE);
    await cache.addAll([
      '/', '/menu', '/menu.json', '/assets/logo.png', '/manifest.json', '/offline.html'
    ]);
  })());
});

self.addEventListener('activate', (event) => {
  event.waitUntil((async () => {
    const keys = await caches.keys();
    await Promise.all(keys.filter(k => !k.endsWith(VERSION)).map(k => caches.delete(k)));
    await self.clients.claim();
  })());
});

// Strategy: network-first for navigation requests; cache-first for static assets
self.addEventListener('fetch', (event) => {
  const req = event.request;
  const url = new URL(req.url);
  if (req.mode === 'navigate') {
    event.respondWith((async () => {
      try {
        const fresh = await fetch(req);
        const cache = await caches.open(STATIC_CACHE);
        cache.put(req, fresh.clone());
        return fresh;
      } catch (e) {
        const cacheMatch = await caches.match(req);
        return cacheMatch || caches.match(OFFLINE_URL);
      }
    })());
    return;
  }
  if (['style', 'script', 'image'].includes(req.destination) || url.pathname.startsWith('/assets/') || url.pathname.startsWith('/build/')) {
    event.respondWith((async () => {
      const cache = await caches.open(STATIC_CACHE);
      const cached = await cache.match(req);
      const network = fetch(req).then(res => { cache.put(req, res.clone()); return res; }).catch(() => cached);
      return cached || network;
    })());
  }
});
