# Design System Rollout – Next Steps

This document tracks the remaining migration tasks after initial Waves (navigation, orders, cart, menu, checkout).

## 1. Form & Auth Unification (In Progress)
Goal: Replace legacy BREEZE utility classes with semantic `.input`, `.btn`, `.surface` patterns.
Tasks:
- [ ] Replace `text-input.blade.php` styles with design tokens.
- [ ] Update `login`, `register`, password reset views.
- [ ] Convert guest layout container to `surface` variant and themed background.

## 2. Component Extraction
- [ ] `<x-table>` wrapper for consistent headers (sticky, background, divider colors).
- [ ] `<x-form.group>` component to standardize label + input + error spacing.

## 3. Feedback & Alerts
- [x] Flash component (`<x-flash>`).
- [ ] Toast refactor to use semantic colors + optional queue.

## 4. Menu Enhancements
- [ ] Extract `<x-dish-card>`.
- [ ] Add skeleton shimmer for images.

## 5. Accessibility & UX
- [ ] Add `aria-live="polite"` for cart subtotal changes.
- [ ] Add focus ring utilities to pills and category navigation.

## 6. Documentation
- [ ] Summarize token naming & usage guidelines inside README design section.

## 7. Cleanup
- [ ] Remove obsolete inline palette from any remaining pages.
- [ ] Audit for stray `bg-white/80` occurrences to replace with `surface`.

---
Status will be updated as tasks are completed.
