<x-app-layout>
    <x-slot name="header">
        <h2 class="font-semibold text-xl text-gray-800 dark:text-gray-200 leading-tight flex items-center gap-2">
            <i data-lucide="map-pin" class="w-5 h-5 text-indigo-500"></i> Saved Addresses
        </h2>
    </x-slot>
    <div class="py-6" x-data="{ showForm:false }" x-init="AOS.init()">
        <div class="max-w-4xl mx-auto px-4 sm:px-6 lg:px-8 space-y-6">
            @if(session('status'))
                <div class="rounded border border-emerald-200 bg-emerald-50 text-emerald-800 px-4 py-2 text-sm" x-data="{visible:true}" x-show="visible" x-transition.opacity.duration.400ms>{{ session('status') }}</div>
            @endif
            <div class="flex justify-between items-center">
                <p class="text-sm text-gray-600 dark:text-slate-400">Manage frequently used delivery locations. Primary address is pre-selected at checkout.</p>
                <button @click="showForm=!showForm" class="inline-flex items-center gap-2 px-4 py-2 rounded bg-indigo-600 text-white text-sm hover:bg-indigo-700 focus:outline-none focus:ring ring-indigo-400 ring-offset-1 dark:ring-offset-slate-800 transition">
                    <i data-lucide="plus" class="w-4 h-4"></i><span x-text="showForm ? 'Cancel' : 'Add Address'"></span>
                </button>
            </div>
            <form x-show="showForm" x-transition.scale.origin.top.left.duration.250ms method="POST" action="{{ route('account.addresses.store') }}" class="bg-white/80 dark:bg-slate-800/80 border border-white/30 dark:border-slate-700/50 rounded-lg p-4 space-y-4">
                @csrf
                <div>
                    <label class="block text-sm font-medium mb-1">Label (optional)</label>
                    <input name="label" type="text" class="w-full rounded border-gray-300 dark:border-slate-600 dark:bg-slate-900" placeholder="e.g. Home, Office" />
                </div>
                <div>
                    <label class="block text-sm font-medium mb-1">Full Address</label>
                    <textarea name="raw_address" required rows="3" class="w-full rounded border-gray-300 dark:border-slate-600 dark:bg-slate-900" placeholder="House number, street, area, city"></textarea>
                    @error('raw_address')<div class="text-sm text-rose-600 mt-1">{{ $message }}</div>@enderror
                </div>
                <div class="flex justify-end gap-2">
                    <button type="submit" class="inline-flex items-center gap-2 px-4 py-2 rounded bg-emerald-600 text-white text-sm hover:bg-emerald-700 focus:outline-none focus:ring ring-emerald-400 ring-offset-1 dark:ring-offset-slate-800 transition"><i data-lucide="save" class="w-4 h-4"></i> Save</button>
                </div>
            </form>
            <div class="grid md:grid-cols-2 gap-4" data-aos="fade-up" data-aos-delay="50">
                @forelse($addresses as $addr)
                    <div class="group relative overflow-hidden rounded-xl border border-white/30 dark:border-slate-700/50 bg-gradient-to-br from-white/90 to-white/60 dark:from-slate-800 dark:to-slate-800/70 backdrop-blur p-4 shadow-sm hover:shadow-md transition" x-data>
                        <div class="absolute inset-0 opacity-0 group-hover:opacity-100 transition duration-300 pointer-events-none bg-[radial-gradient(circle_at_30%_20%,rgba(99,102,241,0.15),transparent_70%)]"></div>
                        <div class="flex items-start gap-3">
                            <div class="shrink-0 mt-0.5">
                                <i data-lucide="map-pin" class="w-5 h-5 text-indigo-500"></i>
                            </div>
                            <div class="flex-1 space-y-1">
                                <div class="flex items-center gap-2">
                                    <h3 class="font-medium text-sm text-gray-800 dark:text-slate-100">{{ $addr->label ?? 'Address' }}</h3>
                                    @if($addr->is_primary)
                                        <span class="inline-flex items-center gap-1 px-2 py-0.5 rounded text-[10px] font-semibold tracking-wide bg-indigo-600 text-white"><i data-lucide="star" class="w-3 h-3"></i>PRIMARY</span>
                                    @endif
                                </div>
                                <p class="text-xs text-gray-600 dark:text-slate-300 leading-snug">{{ $addr->raw_address }}</p>
                                <div class="flex flex-wrap gap-3 text-[10px] uppercase tracking-wide text-gray-500 dark:text-slate-400">
                                    <span class="inline-flex items-center gap-1"><i data-lucide="clock" class="w-3 h-3"></i>Used {{ $addr->times_used }}x</span>
                                    @if($addr->last_used_at)<span class="inline-flex items-center gap-1"><i data-lucide="history" class="w-3 h-3"></i>{{ $addr->last_used_at->diffForHumans() }}</span>@endif
                                </div>
                            </div>
                        </div>
                        <div class="mt-3 flex items-center justify-end gap-2">
                            @if(!$addr->is_primary)
                                <form method="POST" action="{{ route('account.addresses.primary', $addr) }}">
                                    @csrf
                                    <button class="px-3 py-1.5 text-xs rounded bg-indigo-50 dark:bg-slate-700/60 text-indigo-700 dark:text-indigo-300 hover:bg-indigo-100 dark:hover:bg-slate-700 transition inline-flex items-center gap-1"><i data-lucide="star" class="w-3 h-3"></i>Primary</button>
                                </form>
                            @endif
                            <form method="POST" action="{{ route('account.addresses.destroy', $addr) }}" onsubmit="return confirm('Remove this address?');">
                                @csrf @method('DELETE')
                                <button class="px-3 py-1.5 text-xs rounded bg-rose-50 dark:bg-slate-700/60 text-rose-700 dark:text-rose-300 hover:bg-rose-100 dark:hover:bg-slate-700 transition inline-flex items-center gap-1"><i data-lucide="trash" class="w-3 h-3"></i>Remove</button>
                            </form>
                        </div>
                    </div>
                @empty
                    <div class="col-span-2 text-center py-12 rounded-xl border border-dashed border-gray-300 dark:border-slate-600">
                        <div class="flex flex-col items-center gap-3">
                            <i data-lucide="map-pin" class="w-10 h-10 text-gray-400"></i>
                            <p class="text-sm text-gray-500 dark:text-slate-400">No saved addresses yet. Add one to speed up checkout.</p>
                        </div>
                    </div>
                @endforelse
            </div>
        </div>
    </div>
</x-app-layout>
