<x-admin-layout>
  <x-slot name="header">
    <div>
      <h2 class="font-semibold text-xl flex items-center gap-2"><i data-lucide="map-pin" class="w-5 h-5 text-indigo-500"></i> Address</h2>
      <x-admin.breadcrumbs :items="[[ 'label' => 'Addresses', 'url' => route('admin.addresses.index') ], [ 'label' => 'Detail' ]]" />
    </div>
  </x-slot>
  <div class="py-8" x-data x-init="AOS.init()">
    <div class="max-w-5xl mx-auto px-4 sm:px-6 lg:px-8 space-y-6">
      <div class="grid md:grid-cols-3 gap-6">
        <div class="md:col-span-2 space-y-6">
          <div class="rounded-xl border border-white/30 dark:border-slate-700/50 bg-white/80 dark:bg-slate-800/80 p-6" data-aos="fade-up">
            <h3 class="font-semibold mb-3 flex items-center gap-2 text-sm text-gray-700 dark:text-slate-200"><i data-lucide="info" class="w-4 h-4 text-indigo-500"></i>Core</h3>
            <dl class="text-sm space-y-2">
              <div class="flex justify-between"><dt>ID</dt><dd>{{ $address->id }}</dd></div>
              <div class="flex justify-between"><dt>User</dt><dd>{{ $address->user?->name ?? '—' }}</dd></div>
              <div class="flex justify-between"><dt>Label</dt><dd>{{ $address->label ?? '—' }}</dd></div>
              <div class="flex justify-between"><dt>Primary</dt><dd>{{ $address->is_primary ? 'Yes' : 'No' }}</dd></div>
            </dl>
          </div>
          <div class="rounded-xl border border-white/30 dark:border-slate-700/50 bg-white/80 dark:bg-slate-800/80 p-6" data-aos="fade-up" data-aos-delay="50">
            <h3 class="font-semibold mb-3 flex items-center gap-2 text-sm text-gray-700 dark:text-slate-200"><i data-lucide="align-left" class="w-4 h-4 text-indigo-500"></i>Address</h3>
            <p class="text-sm text-gray-700 dark:text-slate-300 whitespace-pre-line">{{ $address->raw_address }}</p>
            @if($address->formatted_address && $address->formatted_address !== $address->raw_address)
              <div class="mt-2 text-xs text-gray-500 dark:text-slate-400">Formatted: {{ $address->formatted_address }}</div>
            @endif
          </div>
          <div class="rounded-xl border border-white/30 dark:border-slate-700/50 bg-white/80 dark:bg-slate-800/80 p-6" data-aos="fade-up" data-aos-delay="100">
            <h3 class="font-semibold mb-3 flex items-center gap-2 text-sm text-gray-700 dark:text-slate-200"><i data-lucide="activity" class="w-4 h-4 text-indigo-500"></i>Usage</h3>
            <dl class="text-sm space-y-2">
              <div class="flex justify-between"><dt>Times Used</dt><dd>{{ $address->times_used }}</dd></div>
              <div class="flex justify-between"><dt>Last Used</dt><dd>{{ $address->last_used_at?->diffForHumans() ?? '—' }}</dd></div>
              <div class="flex justify-between"><dt>Latitude</dt><dd>{{ $address->latitude ?? '—' }}</dd></div>
              <div class="flex justify-between"><dt>Longitude</dt><dd>{{ $address->longitude ?? '—' }}</dd></div>
            </dl>
          </div>
        </div>
        <div class="space-y-6">
          <div class="rounded-xl border border-white/30 dark:border-slate-700/50 bg-white/80 dark:bg-slate-800/80 p-6" data-aos="fade-left">
            <h3 class="font-semibold mb-3 flex items-center gap-2 text-sm text-gray-700 dark:text-slate-200"><i data-lucide="shopping-bag" class="w-4 h-4 text-indigo-500"></i>Orders</h3>
            <ul class="space-y-2 text-sm max-h-64 overflow-auto pr-1">
              @foreach($address->orders()->latest()->take(50)->get() as $o)
                <li class="flex items-center justify-between gap-2 border-b border-dashed border-gray-200 dark:border-slate-700/50 pb-1">
                  <a href="{{ route('admin.orders.show', $o) }}" class="text-indigo-600 dark:text-indigo-400 hover:underline">#{{ $o->id }}</a>
                  <span class="text-xs text-gray-500 dark:text-slate-400">{{ $o->created_at->diffForHumans() }}</span>
                </li>
              @endforeach
            </ul>
          </div>
        </div>
      </div>
    </div>
  </div>
</x-admin-layout>
