<x-admin-layout>
    <x-slot name="header">
        <div class="flex items-center justify-between">
            <div>
                <h2 class="font-semibold text-xl text-gray-800 dark:text-gray-200 leading-tight">
                    Business Analytics
                </h2>
                <p class="text-sm text-gray-600 dark:text-gray-400 mt-1">
                    Revenue and operational insights
                </p>
            </div>
        </div>
    </x-slot>

    <div class="py-6">
        <div class="container-px max-w-7xl space-y-6">
            
            <!-- Revenue Analytics -->
            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6">
                <div class="surface rounded-xl p-6">
                    <div class="flex items-center justify-between">
                        <div>
                            <p class="text-sm text-gray-600 dark:text-gray-400">Today's Orders</p>
                            <p class="text-2xl font-bold text-gray-900 dark:text-white">{{ $analytics['orders_today'] }}</p>
                        </div>
                        <div class="w-12 h-12 bg-blue-500/10 rounded-full flex items-center justify-center">
                            <svg class="w-6 h-6 text-blue-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5H7a2 2 0 00-2 2v10a2 2 0 002 2h8a2 2 0 002-2V7a2 2 0 00-2-2h-2M9 5a2 2 0 002 2h2a2 2 0 002-2M9 5a2 2 0 012-2h2a2 2 0 012 2"></path>
                            </svg>
                        </div>
                    </div>
                </div>

                <div class="surface rounded-xl p-6">
                    <div class="flex items-center justify-between">
                        <div>
                            <p class="text-sm text-gray-600 dark:text-gray-400">Today's Revenue</p>
                            <p class="text-2xl font-bold text-gray-900 dark:text-white">₦{{ number_format($analytics['revenue_today'], 2) }}</p>
                        </div>
                        <div class="w-12 h-12 bg-green-500/10 rounded-full flex items-center justify-center">
                            <svg class="w-6 h-6 text-green-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8c-1.657 0-3 .895-3 2s1.343 2 3 2 3 .895 3 2-1.343 2-3 2m0-8c1.11 0 2.08.402 2.599 1M12 8V7m0 1v8m0 0v1m0-1c-1.11 0-2.08-.402-2.599-1"></path>
                            </svg>
                        </div>
                    </div>
                </div>

                <div class="surface rounded-xl p-6">
                    <div class="flex items-center justify-between">
                        <div>
                            <p class="text-sm text-gray-600 dark:text-gray-400">Month Orders</p>
                            <p class="text-2xl font-bold text-gray-900 dark:text-white">{{ $analytics['orders_month'] }}</p>
                        </div>
                        <div class="w-12 h-12 bg-purple-500/10 rounded-full flex items-center justify-center">
                            <svg class="w-6 h-6 text-purple-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M16 8v8m-4-5v5m-4-2v2m-2 4h12a2 2 0 002-2V6a2 2 0 00-2-2H6a2 2 0 00-2 2v12a2 2 0 002 2z"></path>
                            </svg>
                        </div>
                    </div>
                </div>

                <div class="surface rounded-xl p-6">
                    <div class="flex items-center justify-between">
                        <div>
                            <p class="text-sm text-gray-600 dark:text-gray-400">Avg Order Value</p>
                            <p class="text-2xl font-bold text-gray-900 dark:text-white">₦{{ number_format($analytics['AOV_month'] ?? 0, 2) }}</p>
                        </div>
                        <div class="w-12 h-12 bg-orange-500/10 rounded-full flex items-center justify-center">
                            <svg class="w-6 h-6 text-orange-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 7h8m0 0v8m0-8l-8 8-4-4-6 6"></path>
                            </svg>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Inventory Performance Widget -->
            @php
                // Pull quick KPIs from InventoryStats
                $inv = \App\Models\InventoryStats::selectRaw('
                    COUNT(*) as tracked,
                    SUM(on_hand) as on_hand,
                    SUM(available) as available,
                    SUM(total_sales_value) as sales_value,
                    SUM(inventory_value) as inventory_value,
                    AVG(velocity_7d) as avg_v7
                ')->first();
            @endphp

            <div class="grid gap-4 sm:grid-cols-2 lg:grid-cols-4 mb-6">
                <div class="rounded-lg border border-white/30 dark:border-slate-700/50 bg-white/80 dark:bg-slate-800/80 p-4">
                    <div class="text-xs uppercase text-slate-500">Inventory Tracked</div>
                    <div class="text-2xl font-semibold">{{ number_format($inv->tracked ?? 0) }}</div>
                </div>
                <div class="rounded-lg border border-white/30 dark:border-slate-700/50 bg-white/80 dark:bg-slate-800/80 p-4">
                    <div class="text-xs uppercase text-slate-500">On Hand (Units)</div>
                    <div class="text-2xl font-semibold">{{ number_format($inv->on_hand ?? 0) }}</div>
                </div>
                <div class="rounded-lg border border-white/30 dark:border-slate-700/50 bg-white/80 dark:bg-slate-800/80 p-4">
                    <div class="text-xs uppercase text-slate-500">Available (Units)</div>
                    <div class="text-2xl font-semibold">{{ number_format($inv->available ?? 0) }}</div>
                </div>
                <div class="rounded-lg border border-white/30 dark:border-slate-700/50 bg-white/80 dark:bg-slate-800/80 p-4">
                    <div class="text-xs uppercase text-slate-500">Avg Velocity (7d)</div>
                    <div class="text-2xl font-semibold">{{ number_format($inv->avg_v7 ?? 0, 2) }} /day</div>
                </div>
            </div>

            <div class="grid gap-4 sm:grid-cols-2 lg:grid-cols-3 mb-8">
                <div class="rounded-lg border border-white/30 dark:border-slate-700/50 bg-white/80 dark:bg-slate-800/80 p-4">
                    <div class="text-xs uppercase text-slate-500">Inventory Value (Est.)</div>
                    <div class="text-2xl font-semibold">₦{{ number_format($inv->inventory_value ?? 0, 2) }}</div>
                </div>
                <div class="rounded-lg border border-white/30 dark:border-slate-700/50 bg-white/80 dark:bg-slate-800/80 p-4">
                    <div class="text-xs uppercase text-slate-500">Sales Value (Lifetime)</div>
                    <div class="text-2xl font-semibold">₦{{ number_format($inv->sales_value ?? 0, 2) }}</div>
                </div>
                <a href="{{ route('admin.inventory.availability') }}" class="rounded-lg border border-white/30 dark:border-slate-700/50 bg-white/80 dark:bg-slate-800/80 p-4 flex items-center justify-between group transition">
                    <div>
                        <div class="text-xs uppercase text-slate-500">Inventory Availability</div>
                        <div class="text-lg font-semibold text-gray-900 dark:text-white">View per-location grid</div>
                    </div>
                    <span class="w-8 h-8 flex items-center justify-center rounded-full bg-slate-200/60 dark:bg-slate-700/60 group-hover:bg-slate-300/80 dark:group-hover:bg-slate-600/80 transition">
                        <i data-lucide="arrow-right" class="w-5 h-5 text-slate-500 group-hover:text-slate-700 dark:text-slate-300 dark:group-hover:text-white"></i>
                    </span>
                </a>
            </div>

            <div class="grid lg:grid-cols-2 gap-6">
                <!-- Top Dishes -->
                <div class="surface rounded-xl p-6">
                    <h3 class="font-semibold text-gray-900 dark:text-white mb-4">Top Selling Dishes</h3>
                    <div class="space-y-3">
                        @foreach($topDishes as $dish)
                        <div class="flex items-center justify-between p-3 bg-gray-50 dark:bg-gray-700/50 rounded-lg">
                            <div class="flex items-center space-x-3">
                                <div class="w-10 h-10 bg-gray-200 dark:bg-gray-600 rounded-lg overflow-hidden">
                                    @php
                                        $imageUrl = $dish->image ? asset('storage/' . $dish->image) : asset('assets/placeholders/dish-placeholder.svg');
                                    @endphp
                                    <img src="{{ $imageUrl }}" 
                                         alt="{{ $dish->name }}" 
                                         class="w-full h-full object-cover"
                                         loading="lazy"
                                         onerror="this.onerror=null;this.src='{{ asset('assets/placeholders/dish-placeholder.svg') }}';" />
                                </div>
                                <div>
                                    <p class="font-medium text-gray-900 dark:text-white">{{ $dish->name }}</p>
                                    <p class="text-sm text-gray-600 dark:text-gray-400">₦{{ number_format($dish->price, 2) }}</p>
                                </div>
                            </div>
                            <div class="text-right">
                                <p class="font-semibold text-primary">{{ $dish->order_count }}</p>
                                <p class="text-xs text-gray-500">orders</p>
                            </div>
                        </div>
                        @endforeach
                    </div>
                </div>

                <!-- Recent Orders -->
                <div class="surface rounded-xl p-6">
                    <div class="flex items-center justify-between mb-4">
                        <h3 class="font-semibold text-gray-900 dark:text-white">Recent Orders</h3>
                        <a href="{{ route('admin.orders.index') }}" class="text-sm text-primary hover:text-primary-600">
                            View All
                        </a>
                    </div>
                    
                    <div class="space-y-3">
                        @foreach($recentOrders as $order)
                        <div class="flex items-center justify-between p-3 bg-gray-50 dark:bg-gray-700/50 rounded-lg">
                            <div class="flex items-center space-x-3">
                                <div class="w-10 h-10 bg-primary/10 rounded-lg flex items-center justify-center">
                                    <span class="text-xs font-semibold text-primary">#{{ $order->id }}</span>
                                </div>
                                <div>
                                    <p class="font-medium text-gray-900 dark:text-white">
                                        {{ $order->user->name ?? 'Guest' }}
                                    </p>
                                    <p class="text-sm text-gray-600 dark:text-gray-400">
                                        {{ $order->created_at->diffForHumans() }}
                                    </p>
                                </div>
                            </div>
                            <div class="text-right">
                                <p class="font-semibold">₦{{ number_format($order->total, 2) }}</p>
                                <x-status-badge :status="$order->status" />
                            </div>
                        </div>
                        @endforeach
                    </div>
                </div>
            </div>

            <!-- Customer Stats -->
            <div class="surface rounded-xl p-6">
                <h3 class="font-semibold text-gray-900 dark:text-white mb-4">Customer Analytics</h3>
                <div class="grid grid-cols-2 md:grid-cols-4 gap-6">
                    <div class="text-center">
                        <p class="text-2xl font-bold text-gray-900 dark:text-white">{{ $customerStats['total_customers'] }}</p>
                        <p class="text-sm text-gray-600 dark:text-gray-400">Total Customers</p>
                    </div>
                    <div class="text-center">
                        <p class="text-2xl font-bold text-gray-900 dark:text-white">{{ $customerStats['new_customers_month'] }}</p>
                        <p class="text-sm text-gray-600 dark:text-gray-400">New This Month</p>
                    </div>
                    <div class="text-center">
                        <p class="text-2xl font-bold text-gray-900 dark:text-white">₦{{ number_format($analytics['revenue_month'], 2) }}</p>
                        <p class="text-sm text-gray-600 dark:text-gray-400">Month Revenue</p>
                    </div>
                    <div class="text-center">
                        <p class="text-2xl font-bold text-gray-900 dark:text-white">{{ number_format(($analytics['revenue_month'] / max($analytics['orders_month'], 1)), 2) }}%</p>
                        <p class="text-sm text-gray-600 dark:text-gray-400">Growth Rate</p>
                    </div>
                </div>
            </div>

            @if(isset($missingImages) && $missingImages->count())
            <div class="surface rounded-xl p-6">
                <div class="flex items-center justify-between mb-3">
                    <h3 class="font-semibold text-gray-900 dark:text-white">Image Diagnostics</h3>
                    <span class="text-xs px-2 py-1 rounded-full bg-red-500/10 text-red-600">{{ $missingImages->count() }} missing</span>
                </div>
                <p class="text-sm text-gray-600 dark:text-gray-400 mb-3">These dishes have no resolvable image URL. Ensure the file exists in public/storage/dishes or public/assets/images, or set an absolute URL in the image field.</p>
                <div class="overflow-auto">
                    <table class="w-full text-sm">
                        <thead class="text-left text-gray-500 dark:text-gray-400">
                            <tr>
                                <th class="py-2 pr-3">ID</th>
                                <th class="py-2 pr-3">Name</th>
                                <th class="py-2 pr-3">Image field</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($missingImages as $d)
                            <tr class="border-t border-gray-200/50 dark:border-gray-700/50">
                                <td class="py-2 pr-3">{{ $d->id }}</td>
                                <td class="py-2 pr-3">{{ $d->name }}</td>
                                <td class="py-2 pr-3">{{ $d->image ?: '—' }}</td>
                            </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
                <div class="mt-3 text-xs text-gray-500 dark:text-gray-400">
                    <p>Accepted locations under public/: storage/dishes/, storage/, assets/dishes/, assets/images/, assets/dishes/originals/.</p>
                    <p>Tip: run <code>php artisan storage:link</code> if using storage-backed images.</p>
                </div>
            </div>
            @endif
        </div>
    </div>
</x-admin-layout>