<x-admin-layout>
  <x-slot name="header">
    <div>
      <h2 class="font-semibold text-xl">New Category</h2>
      <x-admin.breadcrumbs :items="[[ 'label' => 'Categories', 'url' => route('admin.categories.index') ], [ 'label' => 'New' ]]" />
    </div>
  </x-slot>

  <div class="max-w-xl mx-auto p-6">
    <form method="POST" action="{{ route('admin.categories.store') }}" class="space-y-4">
    @csrf
      @if ($errors->any())
        <div class="rounded border border-red-200 bg-red-50 text-red-800 px-4 py-2">
          <div class="font-medium">Please fix the errors below</div>
        </div>
      @endif
      <div class="bg-white/80 dark:bg-slate-800/80 rounded-lg border border-white/30 dark:border-slate-700/50 p-4">
        <div>
          <label class="block text-sm font-medium mb-1">Name</label>
          <input type="text" name="name" value="{{ old('name') }}" class="w-full border rounded px-3 py-2 dark:bg-slate-900 dark:border-slate-700 @error('name') border-red-500 @enderror" required>
          @error('name')<div class="text-sm text-red-600 mt-1">{{ $message }}</div>@enderror
        </div>
      </div>
      <div class="flex gap-2">
        <a class="inline-flex items-center gap-2 px-4 py-2 border rounded dark:border-slate-600 hover:bg-gray-50 dark:hover:bg-slate-800" href="{{ route('admin.categories.index') }}"><i data-lucide="arrow-left" class="w-4 h-4"></i>Cancel</a>
        <button class="inline-flex items-center gap-2 px-4 py-2 bg-indigo-600 text-white rounded hover:bg-indigo-700"><i data-lucide="save" class="w-4 h-4"></i>Create</button>
      </div>
    </form>
  </div>
</x-admin-layout>
