<x-admin-layout>
  <x-slot name="header">
    <div>
      <h2 class="font-semibold text-xl">Categories</h2>
      <x-admin.breadcrumbs :items="[[ 'label' => 'Categories' ]]" />
    </div>
  </x-slot>

  <div class="py-6">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8" data-aos="fade-up">
      <div class="flex items-center justify-between mb-4">
        <h1 class="text-lg font-semibold">All Categories</h1>
        <a class="inline-flex items-center gap-2 px-4 py-2 bg-indigo-600 text-white rounded hover:bg-indigo-700" href="{{ route('admin.categories.create') }}"><i data-lucide= "plus" class="w-4 h-4"></i> New Category</a>
      </div>

      @if(session('status'))
        <div class="mb-4 rounded border border-emerald-200 bg-emerald-50 text-emerald-800 px-4 py-2">{{ session('status') }}</div>
      @endif

      <form method="GET" class="mb-3 grid gap-2 sm:grid-cols-4 text-sm" id="categories-filters-form" role="search">
        <div class="sm:col-span-2 relative">
          <label class="sr-only" for="categories-q">Search</label>
          <input id="categories-q" name="q" value="{{ $q ?? request('q') }}" placeholder="Search categories" class="w-full border rounded px-3 py-2 pr-8 dark:bg-slate-900 dark:border-slate-700" />
          <button type="button" id="categories-clear-q" aria-label="Clear search" class="absolute right-2 top-1/2 -translate-y-1/2 text-gray-400 hover:text-gray-700 dark:hover:text-gray-200 {{ ($q ?? request('q')) ? '' : 'hidden' }}">&times;</button>
        </div>
        <div>
          <label class="sr-only" for="perPage">Per page</label>
          <select id="perPage" name="perPage" class="w-full border rounded px-3 py-2 dark:bg-slate-900 dark:border-slate-700">
            @foreach([10,15,25,50,100] as $n)
              <option value="{{ $n }}" @selected(($perPage ?? 15) == $n)>{{ $n }} / page</option>
            @endforeach
          </select>
        </div>
        <div class="flex gap-2">
          <button class="px-4 py-2 bg-indigo-600 text-white rounded">Apply</button>
          <a href="{{ route('admin.categories.index') }}" class="px-4 py-2 border rounded dark:border-slate-600">Reset</a>
        </div>
      </form>

      <div class="overflow-hidden rounded-lg border border-white/30 dark:border-slate-700/50 bg-white/80 dark:bg-slate-800/80">
        <div class="overflow-x-auto">
          <table class="min-w-full text-sm">
            @php
              $curSort = $sort ?? request('sort','name');
              $curDir = $dir ?? request('dir','asc');
              $dirFlip = $curDir === 'asc' ? 'desc' : 'asc';
              $qs = request()->except(['page','sort','dir']);
            @endphp
            <thead class="sticky top-0 z-10 bg-gray-50/90 dark:bg-slate-900/70 backdrop-blur text-left text-gray-700 dark:text-slate-300">
              <tr>
                <th class="px-4 py-3">
                  @php $params = array_merge($qs,['sort'=>'name','dir'=>$curSort==='name'?$dirFlip:'asc']); @endphp
                  <a href="{{ request()->url().'?'.http_build_query($params) }}" class="inline-flex items-center gap-1">
                    Name <span class="opacity-60">@if($curSort==='name') {{ $curDir==='asc'?'▲':'▼' }} @endif</span>
                  </a>
                </th>
                <th class="px-4 py-3 text-right">Actions</th>
              </tr>
            </thead>
            <tbody class="divide-y divide-gray-100/60 dark:divide-slate-700/50">
              @forelse($categories as $category)
              <tr>
                <td class="px-4 py-3">{{ $category->name }}</td>
                <td class="px-4 py-3 text-right">
                  <div class="relative inline-block text-left">
                    <button onclick="toggleDropdown({{ $category->id }})" 
                            class="inline-flex items-center gap-1 px-3 py-1.5 border border-gray-300 dark:border-slate-600 rounded hover:bg-gray-50 dark:hover:bg-slate-700 transition-colors">
                      <i data-lucide="more-horizontal" class="w-4 h-4"></i>
                      Actions
                      <i data-lucide="chevron-down" class="w-4 h-4"></i>
                    </button>
                    
                    <div id="dropdown-{{ $category->id }}" class="hidden absolute right-0 z-10 mt-1 w-48 origin-top-right rounded-md bg-white dark:bg-slate-800 shadow-lg ring-1 ring-black ring-opacity-5 dark:ring-slate-700 focus:outline-none">
                      <div class="py-1">
                        <a href="{{ route('admin.categories.edit', $category) }}" 
                           class="group flex items-center gap-3 px-4 py-2 text-sm text-gray-700 dark:text-gray-300 hover:bg-gray-100 dark:hover:bg-slate-700 transition-colors">
                          <i data-lucide="pencil" class="w-4 h-4 text-gray-400 group-hover:text-gray-600 dark:group-hover:text-gray-300"></i>
                          Edit
                        </a>
                        
                        <div class="border-t border-gray-100 dark:border-slate-700"></div>
                        
                        <form action="{{ route('admin.categories.destroy', $category) }}" method="POST" class="block" onsubmit="return confirm('Delete this category?')">
                          @csrf
                          @method('DELETE')
                          <button type="submit" class="group flex items-center gap-3 px-4 py-2 text-sm text-red-700 dark:text-red-400 hover:bg-red-50 dark:hover:bg-red-900/20 w-full text-left transition-colors">
                            <i data-lucide="trash-2" class="w-4 h-4 text-red-400 group-hover:text-red-600 dark:group-hover:text-red-300"></i>
                            Delete
                          </button>
                        </form>
                      </div>
                    </div>
                  </div>
                </td>
              </tr>
              @empty
              <tr>
                <td colspan="2" class="px-4 py-10 text-center text-gray-500">
                  <div class="flex flex-col items-center gap-2">
                    <i data-lucide="folder-plus" class="w-6 h-6"></i>
                    <div>No categories found.</div>
                    <a class="inline-flex items-center gap-2 px-3 py-1.5 bg-indigo-600 text-white rounded hover:bg-indigo-700" href="{{ route('admin.categories.create') }}"><i data-lucide="plus" class="w-4 h-4"></i> Create your first category</a>
                  </div>
                </td>
              </tr>
              @endforelse
            </tbody>
          </table>
        </div>
      </div>
      <div class="mt-4">{{ $categories->appends(request()->except('page'))->links() }}</div>
    </div>
  </div>
  <script>
    (function(){
      const form = document.getElementById('categories-filters-form');
      if (!form) return;
      const q = document.getElementById('categories-q');
      const clearBtn = document.getElementById('categories-clear-q');
      form.querySelectorAll('select').forEach(el => el.addEventListener('change', ()=> form.requestSubmit()));
      let t;
      q?.addEventListener('input', ()=>{ clearBtn?.classList.toggle('hidden', q.value.trim()===''); clearTimeout(t); t = setTimeout(()=>form.requestSubmit(),500); });
      q?.addEventListener('keydown', (e)=>{ if (e.key==='Escape'){ q.value=''; clearBtn?.classList.add('hidden'); form.requestSubmit(); }});
      clearBtn?.addEventListener('click', ()=>{ if (q){ q.value=''; clearBtn.classList.add('hidden'); form.requestSubmit(); }});
    })();
  </script>

  {{-- Dropdown Toggle Script --}}
  <script>
    function toggleDropdown(categoryId) {
      // Close all other dropdowns first
      document.querySelectorAll('[id^="dropdown-"]').forEach(dropdown => {
        if (dropdown.id !== `dropdown-${categoryId}`) {
          dropdown.classList.add('hidden');
        }
      });
      
      // Toggle the current dropdown
      const dropdown = document.getElementById(`dropdown-${categoryId}`);
      dropdown.classList.toggle('hidden');
    }
    
    // Close dropdowns when clicking outside
    document.addEventListener('click', function(e) {
      if (!e.target.closest('[id^="dropdown-"]') && !e.target.closest('button[onclick*="toggleDropdown"]')) {
        document.querySelectorAll('[id^="dropdown-"]').forEach(dropdown => {
          dropdown.classList.add('hidden');
        });
      }
    });
    
    // Close dropdowns on escape key
    document.addEventListener('keydown', function(e) {
      if (e.key === 'Escape') {
        document.querySelectorAll('[id^="dropdown-"]').forEach(dropdown => {
          dropdown.classList.add('hidden');
        });
      }
    });
  </script>
</x-admin-layout>
