<x-admin-layout title="Contact Messages">
  <div class="flex items-center justify-between mb-4">
    <h1 class="text-xl font-semibold">Contact Messages</h1>
  </div>

  @isset($dbUnavailable)
    @if($dbUnavailable)
      <div class="mb-4 rounded-md border border-amber-300/60 bg-amber-50 text-amber-900 dark:bg-amber-950/40 dark:text-amber-200 p-3">
        The database is currently unavailable. Showing an empty list for now.
      </div>
    @endif
  @endisset

  <div class="rounded-lg border border-white/30 dark:border-slate-700/50 bg-white/80 dark:bg-slate-800/80 overflow-x-auto">
    <table class="min-w-full text-sm">
      <thead class="text-left bg-white/60 dark:bg-slate-900/60">
        <tr>
          <th class="px-3 py-2">Date</th>
          <th class="px-3 py-2">Name</th>
          <th class="px-3 py-2">Email</th>
          <th class="px-3 py-2">Phone</th>
          <th class="px-3 py-2">Subject</th>
          <th class="px-3 py-2">Message</th>
          <th class="px-3 py-2">IP</th>
        </tr>
      </thead>
      <tbody>
        @forelse($messages as $m)
          <tr class="border-t border-white/30 dark:border-slate-700/50">
            <td class="px-3 py-2 whitespace-nowrap">{{ $m->created_at->format('Y-m-d H:i') }}</td>
            <td class="px-3 py-2">{{ $m->name }}</td>
            <td class="px-3 py-2"><a href="mailto:{{ $m->email }}" class="underline">{{ $m->email }}</a></td>
            <td class="px-3 py-2">{{ $m->phone }}</td>
            <td class="px-3 py-2">{{ $m->subject }}</td>
            <td class="px-3 py-2 max-w-[28ch] truncate" title="{{ $m->message }}">{{ $m->message }}</td>
            <td class="px-3 py-2">{{ $m->ip }}</td>
          </tr>
        @empty
          <tr>
            <td colspan="7" class="px-3 py-8 text-center text-slate-500">No messages yet.</td>
          </tr>
        @endforelse
      </tbody>
    </table>
  </div>

  <div class="mt-3">{{ $messages->links() }}</div>
</x-admin-layout>
