<x-admin-layout>
  <x-slot name="header">
    <div class="flex items-center justify-between">
      <div>
        <h2 class="font-semibold text-xl">Admin</h2>
        <x-admin.breadcrumbs :items="[]" />
      </div>
    </div>
  </x-slot>

  <div class="py-6">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
      <div class="mb-6 text-slate-600 dark:text-slate-300">Welcome, {{ auth()->user()->name ?? 'Admin' }}.</div>
      <div class="grid sm:grid-cols-2 lg:grid-cols-3 gap-4" data-aos="fade-up">
        <a href="{{ route('admin.settings.index') }}" class="card rounded-lg border border-white/30 dark:border-slate-700/50 bg-white/80 dark:bg-slate-800/80 p-5 hover:shadow-lg">
          <div class="flex items-center gap-3 mb-2">
            <i data-lucide="settings" class="w-5 h-5 text-slate-700"></i>
            <div class="font-semibold">Settings</div>
          </div>
          <div class="text-sm text-slate-600 dark:text-slate-300">Business hours, fees, capacity, room service.</div>
        </a>
        <a href="{{ route('admin.categories.index') }}" class="card rounded-lg border border-white/30 dark:border-slate-700/50 bg-white/80 dark:bg-slate-800/80 p-5 hover:shadow-lg">
          <div class="flex items-center gap-3 mb-2">
            <i data-lucide="layout-grid" class="w-5 h-5 text-indigo-600"></i>
            <div class="font-semibold">Manage Categories</div>
          </div>
          <div class="text-sm text-slate-600 dark:text-slate-300">Create and edit menu categories.</div>
        </a>
        <a href="{{ route('admin.dishes.index') }}" class="card rounded-lg border border-white/30 dark:border-slate-700/50 bg-white/80 dark:bg-slate-800/80 p-5 hover:shadow-lg">
          <div class="flex items-center gap-3 mb-2">
            <i data-lucide="utensils" class="w-5 h-5 text-amber-500"></i>
            <div class="font-semibold">Manage Dishes</div>
          </div>
          <div class="text-sm text-slate-600 dark:text-slate-300">Add and update dishes and prices.</div>
        </a>
        <a href="{{ route('admin.orders.index') }}" class="card rounded-lg border border-white/30 dark:border-slate-700/50 bg-white/80 dark:bg-slate-800/80 p-5 hover:shadow-lg">
          <div class="flex items-center gap-3 mb-2">
            <i data-lucide="receipt" class="w-5 h-5 text-emerald-500"></i>
            <div class="font-semibold">Orders</div>
          </div>
          <div class="text-sm text-slate-600 dark:text-slate-300">View and update order statuses.</div>
        </a>
      </div>
    </div>
  </div>
</x-admin-layout>
