<x-admin-layout>
  <x-slot name="header">
    <div>
      <h2 class="font-semibold text-xl">New Dish</h2>
      <x-admin.breadcrumbs :items="[[ 'label' => 'Dishes', 'url' => route('admin.dishes.index') ], [ 'label' => 'New' ]]" />
    </div>
  </x-slot>

  <div class="max-w-5xl mx-auto">
    <form method="POST" action="{{ route('admin.dishes.store') }}" enctype="multipart/form-data" class="space-y-6">
      @csrf
      @if ($errors->any())
        <div class="rounded border border-red-200 bg-red-50 text-red-800 px-4 py-2">
          <div class="font-medium">Please fix the errors below</div>
        </div>
      @endif
      <div class="bg-white/80 dark:bg-slate-800/80 rounded-lg border border-white/30 dark:border-slate-700/50 p-4">
        <div class="grid sm:grid-cols-2 gap-4">
          <div>
            <label class="block text-sm font-medium mb-1">Name</label>
            <input type="text" name="name" value="{{ old('name') }}" class="w-full border rounded px-3 py-2 dark:bg-slate-900 dark:border-slate-700 @error('name') border-red-500 @enderror" required>
            @error('name')<div class="text-sm text-red-600 mt-1">{{ $message }}</div>@enderror
          </div>
          <div>
            <label class="block text-sm font-medium mb-1">Category</label>
            <select name="category_id" class="w-full border rounded px-3 py-2 dark:bg-slate-900 dark:border-slate-700">
              <option value="">— None —</option>
              @foreach($categories as $cat)
                <option value="{{ $cat->id }}" @selected(old('category_id')==$cat->id)>{{ $cat->name }}</option>
              @endforeach
            </select>
          </div>
          <div>
            <label class="block text-sm font-medium mb-1">Price</label>
            <input type="number" step="0.01" name="price" value="{{ old('price') }}" class="w-full border rounded px-3 py-2 dark:bg-slate-900 dark:border-slate-700 @error('price') border-red-500 @enderror" required>
            @error('price')<div class="text-sm text-red-600 mt-1">{{ $message }}</div>@enderror
          </div>
          <div>
            <label class="block text-sm font-medium mb-1">Initial Stock</label>
            <input type="number" step="1" min="0" name="stock" value="{{ old('stock', 0) }}" class="w-full border rounded px-3 py-2 dark:bg-slate-900 dark:border-slate-700 @error('stock') border-red-500 @enderror">
            @error('stock')<div class="text-sm text-red-600 mt-1">{{ $message }}</div>@enderror
          </div>
          <div>
            <label class="block text-sm font-medium mb-1">Low Stock Threshold</label>
            <input type="number" step="1" min="0" name="low_stock_threshold" value="{{ old('low_stock_threshold', 5) }}" class="w-full border rounded px-3 py-2 dark:bg-slate-900 dark:border-slate-700 @error('low_stock_threshold') border-red-500 @enderror">
            <div class="text-xs text-gray-500 dark:text-gray-400 mt-1">Alert when stock falls below this amount</div>
            @error('low_stock_threshold')<div class="text-sm text-red-600 mt-1">{{ $message }}</div>@enderror
          </div>
          <div class="sm:col-span-2">
            <label class="block text-sm font-medium mb-1">Description</label>
            <textarea name="description" rows="3" class="w-full border rounded px-3 py-2 dark:bg-slate-900 dark:border-slate-700">{{ old('description') }}</textarea>
          </div>
          <div>
            <label class="block text-sm font-medium mb-1">Image</label>
            <input type="file" name="image" accept="image/*" class="w-full border rounded px-3 py-2 dark:bg-slate-900 dark:border-slate-700 @error('image') border-red-500 @enderror" onchange="previewDishCreate(this)">
            @error('image')<div class="text-sm text-red-600 mt-1">{{ $message }}</div>@enderror
            <img id="dish-create-preview" src="#" alt="Preview" class="mt-2 rounded border border-white/30 dark:border-slate-700/50 hidden max-w-xs h-auto" />
          </div>
          <div class="flex items-center gap-2">
            <input class="h-4 w-4 rounded border-slate-300 text-indigo-600 focus:ring-indigo-500" type="checkbox" name="vegetarian" value="1" @checked(old('vegetarian'))>
            <label class="text-sm">Vegetarian</label>
          </div>
          <div class="flex items-center gap-2">
            <input class="h-4 w-4 rounded border-slate-300 text-indigo-600 focus:ring-indigo-500" type="checkbox" name="halal" value="1" @checked(old('halal', true))>
            <label class="text-sm">Halal</label>
          </div>
          <div class="flex items-center gap-2">
            <input class="h-4 w-4 rounded border-slate-300 text-indigo-600 focus:ring-indigo-500" type="checkbox" name="gluten_free" value="1" @checked(old('gluten_free'))>
            <label class="text-sm">Gluten Free</label>
          </div>
        </div>
      </div>
      <div class="flex gap-2">
        <a class="inline-flex items-center gap-2 px-4 py-2 border rounded dark:border-slate-600 hover:bg-gray-50 dark:hover:bg-slate-800" href="{{ route('admin.dishes.index') }}"><i data-lucide="arrow-left" class="w-4 h-4"></i>Cancel</a>
        <button class="inline-flex items-center gap-2 px-4 py-2 bg-indigo-600 text-white rounded hover:bg-indigo-700"><i data-lucide="save" class="w-4 h-4"></i>Create</button>
      </div>
    </form>
  </div>

  @push('scripts')
  <script>
  function previewDishCreate(input){
      const img = document.getElementById('dish-create-preview');
      if (input.files && input.files[0]){
    img.classList.remove('hidden');
        img.src = URL.createObjectURL(input.files[0]);
      } else {
    img.classList.add('hidden');
        img.src = '#';
      }
    }
  </script>
  @endpush
</x-admin-layout>

 
