<x-admin-layout>
  <x-slot name="header">
    <div>
      <h2 class="font-semibold text-xl">Dishes</h2>
      <x-admin.breadcrumbs :items="[[ 'label' => 'Dishes' ]]" />
    </div>
  </x-slot>

  <div class="py-6">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8" data-aos="fade-up">
      <div class="flex items-center justify-between mb-4">
        <h1 class="text-lg font-semibold">All Dishes</h1>
        <a class="inline-flex items-center gap-2 px-4 py-2 bg-indigo-600 text-white rounded hover:bg-indigo-700" href="{{ route('admin.dishes.create') }}"><i data-lucide="plus" class="w-4 h-4"></i> New Dish</a>
      </div>

      @if(session('status'))
        <div class="mb-4 rounded border border-emerald-200 bg-emerald-50 text-emerald-800 px-4 py-2">{{ session('status') }}</div>
      @endif

  <form method="GET" class="mb-3 grid gap-2 sm:grid-cols-6 text-sm" id="dishes-filters-form" role="search">
        <div class="sm:col-span-2 relative">
          <label class="sr-only" for="dishes-q">Search</label>
          <input id="dishes-q" name="q" value="{{ $q ?? request('q') }}" placeholder="Search dishes or categories" class="w-full border rounded px-3 py-2 pr-8 dark:bg-slate-900 dark:border-slate-700" />
          <button type="button" id="dishes-clear-q" aria-label="Clear search" class="absolute right-2 top-1/2 -translate-y-1/2 text-gray-400 hover:text-gray-700 dark:hover:text-gray-200 {{ ($q ?? request('q')) ? '' : 'hidden' }}">&times;</button>
        </div>
        <div>
          <label class="sr-only" for="category_id">Category</label>
          <select id="category_id" name="category_id" class="w-full border rounded px-3 py-2 dark:bg-slate-900 dark:border-slate-700">
            <option value="">All categories</option>
            @foreach(($categories ?? []) as $c)
              <option value="{{ $c->id }}" @selected(($categoryId ?? request('category_id')) == $c->id)>{{ $c->name }}</option>
            @endforeach
          </select>
        </div>
        <div>
          <label class="sr-only" for="perPage">Per page</label>
          <select id="perPage" name="perPage" class="w-full border rounded px-3 py-2 dark:bg-slate-900 dark:border-slate-700">
            @foreach([10,15,25,50,100] as $n)
              <option value="{{ $n }}" @selected(($perPage ?? 15) == $n)>{{ $n }} / page</option>
            @endforeach
          </select>
        </div>
        <div>
          <label class="sr-only" for="trashed">Trashed</label>
          <select id="trashed" name="trashed" class="w-full border rounded px-3 py-2 dark:bg-slate-900 dark:border-slate-700">
            <option value="0" @selected(empty($showTrashed))>Active</option>
            <option value="1" @selected(!empty($showTrashed))>With Trashed</option>
          </select>
        </div>
        <div class="flex gap-2">
          <button class="px-4 py-2 bg-indigo-600 text-white rounded">Apply</button>
          <a href="{{ route('admin.dishes.index') }}" class="px-4 py-2 border rounded dark:border-slate-600">Reset</a>
        </div>
      </form>

      <div class="overflow-hidden rounded-lg border border-white/30 dark:border-slate-700/50 bg-white/80 dark:bg-slate-800/80">
        <div class="overflow-x-auto">
          <table class="min-w-full text-sm">
            <thead class="sticky top-0 z-10 bg-gray-50/90 dark:bg-slate-900/70 backdrop-blur text-left text-gray-700 dark:text-slate-300">
              @php
                $curSort = $sort ?? request('sort','updated');
                $curDir = $dir ?? request('dir','desc');
                $dirFlip = $curDir === 'asc' ? 'desc' : 'asc';
                $qs = request()->except(['page','sort','dir']);
                $link = function($key) use ($qs,$curSort,$curDir,$dirFlip){
                  $params = array_merge($qs, ['sort'=>$key,'dir'=>$curSort===$key?$dirFlip:'asc']);
                  return request()->url().'?'.http_build_query($params);
                };
                $chev = function($key) use ($curSort,$curDir){
                  if ($curSort !== $key) return '';
                  return $curDir==='asc' ? '▲' : '▼';
                };
              @endphp
              <tr>
                <th class="px-4 py-3 w-20">Image</th>
                <th class="px-4 py-3"><a href="{{ $link('name') }}" class="inline-flex items-center gap-1">Name <span class="opacity-60">{{ $chev('name') }}</span></a></th>
                <th class="px-4 py-3"><a href="{{ $link('category') }}" class="inline-flex items-center gap-1">Category <span class="opacity-60">{{ $chev('category') }}</span></a></th>
                <th class="px-4 py-3"><a href="{{ $link('price') }}" class="inline-flex items-center gap-1">Price <span class="opacity-60">{{ $chev('price') }}</span></a></th>
                <th class="px-4 py-3">Stock</th>
                <th class="px-4 py-3">Last Movement</th>
                <th class="px-4 py-3">Deleted</th>
                <th class="px-4 py-3 text-right">Actions</th>
              </tr>
            </thead>
            <tbody class="divide-y divide-gray-100/60 dark:divide-slate-700/50">
              @forelse($dishes as $dish)
              <tr>
                <td class="px-4 py-3">
                  @php
                    $img = $dish->public_image_url ?: asset('assets/placeholders/dish-placeholder.svg');
                    $base = $dish->image_base;
                    $manifestEntry = $base ? App\Support\ImageManifest::find('dish', $base) : null;
                  @endphp
                  @if($base && $manifestEntry)
                    <x-responsive-image type="dish" :base="$base" :alt="$dish->name" class="h-14 w-14 rounded-md object-cover border border-white/30 dark:border-slate-700/50 bg-white/30" sizes="56px" :fallback="$img" />
                  @else
                    <img src="{{ $img }}" alt="{{ $dish->name }}" class="h-14 w-14 object-cover rounded-md border border-white/30 dark:border-slate-700/50 bg-white/50" width="56" height="56" loading="lazy">
                  @endif
                </td>
                <td class="px-4 py-3">{{ $dish->name }}</td>
                <td class="px-4 py-3">{{ $dish->category?->name ?? '-' }}</td>
                <td class="px-4 py-3">₦{{ number_format($dish->price, 2) }}</td>
                <td class="px-4 py-3">
                  @if(\Illuminate\Support\Facades\Schema::hasColumn('dishes','stock'))
                    <div class="flex items-center gap-2">
                      <span class="font-medium">{{ (int)($dish->stock ?? 0) }}</span>
                      @if($dish->isOutOfStock())
                        <span class="inline-flex items-center gap-1 px-2 py-0.5 text-xs rounded-full bg-red-100 text-red-700 dark:bg-red-900/40 dark:text-red-300">
                          <i data-lucide="alert-circle" class="w-3 h-3"></i>
                          Out of Stock
                        </span>
                      @elseif($dish->isLowStock())
                        <span class="inline-flex items-center gap-1 px-2 py-0.5 text-xs rounded-full bg-amber-100 text-amber-700 dark:bg-amber-900/40 dark:text-amber-300">
                          <i data-lucide="alert-triangle" class="w-3 h-3"></i>
                          Low Stock
                        </span>
                      @endif
                    </div>
                  @else
                    —
                  @endif
                </td>
                <td class="px-4 py-3 text-gray-600 dark:text-gray-300">
                  @if(!empty($dish->last_movement_at))
                    {{ \Carbon\Carbon::parse($dish->last_movement_at)->diffForHumans() }}
                  @else
                    —
                  @endif
                </td>
                <td class="px-4 py-3">
                  @if($dish->deleted_at)
                    <span class="inline-flex items-center px-2 py-0.5 text-xs rounded bg-red-100 text-red-700 dark:bg-red-900/40 dark:text-red-300">{{ $dish->deleted_at->diffForHumans() }}</span>
                  @else
                    <span class="text-xs text-gray-400">—</span>
                  @endif
                </td>
                <td class="px-4 py-3 text-right">
                  <div class="relative inline-block text-left">
                    <button onclick="toggleDropdown({{ $dish->id }})" 
                            class="inline-flex items-center gap-1 px-3 py-1.5 border border-gray-300 dark:border-slate-600 rounded hover:bg-gray-50 dark:hover:bg-slate-700 transition-colors">
                      <i data-lucide="more-horizontal" class="w-4 h-4"></i>
                      Actions
                      <i data-lucide="chevron-down" class="w-4 h-4"></i>
                    </button>
                    
                    <div id="dropdown-{{ $dish->id }}" class="hidden absolute right-0 z-10 mt-1 w-56 origin-top-right rounded-md bg-white dark:bg-slate-800 shadow-lg ring-1 ring-black ring-opacity-5 dark:ring-slate-700 focus:outline-none">
                      <div class="py-1">
                        @if(\Illuminate\Support\Facades\Route::has('admin.dishes.inventory.history'))
                          <a href="{{ route('admin.dishes.inventory.history', $dish) }}" 
                             class="group flex items-center gap-3 px-4 py-2 text-sm text-gray-700 dark:text-gray-300 hover:bg-gray-100 dark:hover:bg-slate-700 transition-colors">
                            <i data-lucide="boxes" class="w-4 h-4 text-gray-400 group-hover:text-gray-600 dark:group-hover:text-gray-300"></i>
                            Inventory History
                          </a>
                        @endif
                        
                        @if(!$dish->deleted_at && \Illuminate\Support\Facades\Schema::hasColumn('dishes','stock'))
                          <button onclick="openAdjustModal({{ $dish->id }}, '{{ addslashes($dish->name) }}', {{ $dish->stock ?? 0 }}); toggleDropdown({{ $dish->id }})" 
                                  class="group flex items-center gap-3 px-4 py-2 text-sm text-blue-700 dark:text-blue-400 hover:bg-blue-50 dark:hover:bg-blue-900/20 w-full text-left transition-colors">
                            <i data-lucide="trending-up" class="w-4 h-4 text-blue-400 group-hover:text-blue-600 dark:group-hover:text-blue-300"></i>
                            Adjust Stock
                          </button>
                        @endif
                        
                        @if($dish->deleted_at)
                          <form action="{{ route('admin.dishes.restore', $dish->id) }}" method="POST" class="block">
                            @csrf
                            <button type="submit" class="group flex items-center gap-3 px-4 py-2 text-sm text-emerald-700 dark:text-emerald-400 hover:bg-emerald-50 dark:hover:bg-emerald-900/20 w-full text-left transition-colors">
                              <i data-lucide="rotate-ccw" class="w-4 h-4 text-emerald-400 group-hover:text-emerald-600 dark:group-hover:text-emerald-300"></i>
                              Restore
                            </button>
                          </form>
                          
                          <form action="{{ route('admin.dishes.force-delete', $dish->id) }}" method="POST" class="block" onsubmit="return confirm('Permanently delete this dish and its image?')">
                            @csrf
                            @method('DELETE')
                            <button type="submit" class="group flex items-center gap-3 px-4 py-2 text-sm text-red-700 dark:text-red-400 hover:bg-red-50 dark:hover:bg-red-900/20 w-full text-left transition-colors">
                              <i data-lucide="trash-2" class="w-4 h-4 text-red-400 group-hover:text-red-600 dark:group-hover:text-red-300"></i>
                              Force Delete
                            </button>
                          </form>
                        @else
                          <a href="{{ route('admin.dishes.edit', $dish) }}" 
                             class="group flex items-center gap-3 px-4 py-2 text-sm text-gray-700 dark:text-gray-300 hover:bg-gray-100 dark:hover:bg-slate-700 transition-colors">
                            <i data-lucide="pencil" class="w-4 h-4 text-gray-400 group-hover:text-gray-600 dark:group-hover:text-gray-300"></i>
                            Edit
                          </a>
                          
                          <div class="border-t border-gray-100 dark:border-slate-700"></div>
                          
                          <form action="{{ route('admin.dishes.destroy', $dish) }}" method="POST" class="block" onsubmit="return confirm('Delete this dish?')">
                            @csrf
                            @method('DELETE')
                            <button type="submit" class="group flex items-center gap-3 px-4 py-2 text-sm text-red-700 dark:text-red-400 hover:bg-red-50 dark:hover:bg-red-900/20 w-full text-left transition-colors">
                              <i data-lucide="trash-2" class="w-4 h-4 text-red-400 group-hover:text-red-600 dark:group-hover:text-red-300"></i>
                              Delete
                            </button>
                          </form>
                        @endif
                      </div>
                    </div>
                  </div>
                </td>
              </tr>
              @empty
              <tr>
                <td colspan="5" class="px-4 py-10 text-center text-gray-500">
                  <div class="flex flex-col items-center gap-2">
                    <i data-lucide="utensils" class="w-6 h-6"></i>
                    <div>No dishes found.</div>
                    <a class="inline-flex items-center gap-2 px-3 py-1.5 bg-indigo-600 text-white rounded hover:bg-indigo-700" href="{{ route('admin.dishes.create') }}"><i data-lucide="plus" class="w-4 h-4"></i> Create your first dish</a>
                  </div>
                </td>
              </tr>
              @endforelse
            </tbody>
          </table>
        </div>
      </div>
      <div class="mt-4">{{ $dishes->appends(request()->except('page'))->links() }}</div>
    </div>
  </div>
  <script>
    (function(){
      const form = document.getElementById('dishes-filters-form');
      if (!form) return;
      const q = document.getElementById('dishes-q');
      const clearBtn = document.getElementById('dishes-clear-q');
      form.querySelectorAll('select').forEach(el => el.addEventListener('change', ()=> form.requestSubmit()));
      let t;
      q?.addEventListener('input', ()=>{ clearBtn?.classList.toggle('hidden', q.value.trim()===''); clearTimeout(t); t = setTimeout(()=>form.requestSubmit(),500); });
      q?.addEventListener('keydown', (e)=>{ if (e.key==='Escape'){ q.value=''; clearBtn?.classList.add('hidden'); form.requestSubmit(); }});
      clearBtn?.addEventListener('click', ()=>{ if (q){ q.value=''; clearBtn.classList.add('hidden'); form.requestSubmit(); }});
    })();
  </script>

  {{-- Stock Adjustment Modal --}}
  <div id="adjustModal" class="fixed inset-0 bg-black bg-opacity-50 hidden items-center justify-center z-50">
    <div class="bg-white dark:bg-slate-800 rounded-lg p-6 max-w-md w-full mx-4">
      <div class="flex items-center justify-between mb-4">
        <h3 class="text-lg font-semibold text-gray-900 dark:text-white">Adjust Stock</h3>
        <button onclick="closeAdjustModal()" class="text-gray-400 hover:text-gray-600 dark:hover:text-gray-300">
          <i data-lucide="x" class="w-5 h-5"></i>
        </button>
      </div>
      
      <form id="adjustForm" method="POST" action="">
        @csrf
        <div class="space-y-4">
          <div>
            <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-1">Dish</label>
            <div id="dishInfo" class="text-gray-900 dark:text-white font-medium"></div>
            <div class="text-sm text-gray-500 dark:text-gray-400">Current stock: <span id="currentStock"></span></div>
          </div>
          
          <div>
            <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-1">Change Amount</label>
            <input type="number" name="change" id="changeAmount" step="1" required
                   class="w-full border border-gray-300 dark:border-gray-600 rounded-lg px-3 py-2 bg-white dark:bg-slate-900 text-gray-900 dark:text-white"
                   placeholder="e.g. 10 or -5">
            <div class="text-xs text-gray-500 dark:text-gray-400 mt-1">
              Use positive numbers to increase stock, negative to decrease
            </div>
          </div>
          
          <div>
            <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-1">Reason</label>
            <select name="reason" required class="w-full border border-gray-300 dark:border-gray-600 rounded-lg px-3 py-2 bg-white dark:bg-slate-900 text-gray-900 dark:text-white">
              <option value="">Select reason...</option>
              <option value="adjustment">Stock Adjustment</option>
              <option value="correction">Data Correction</option>
              <option value="receipt">Stock Receipt</option>
              <option value="spoilage">Spoilage</option>
              <option value="shrinkage">Shrinkage</option>
              <option value="return">Customer Return</option>
            </select>
          </div>
          
          <div>
            <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-1">Note (Optional)</label>
            <textarea name="note" rows="2" 
                      class="w-full border border-gray-300 dark:border-gray-600 rounded-lg px-3 py-2 bg-white dark:bg-slate-900 text-gray-900 dark:text-white"
                      placeholder="Additional details..."></textarea>
          </div>
          
          <div class="flex justify-end space-x-3 pt-4">
            <button type="button" onclick="closeAdjustModal()" 
                    class="px-4 py-2 border border-gray-300 dark:border-gray-600 rounded-lg hover:bg-gray-50 dark:hover:bg-slate-700 transition-colors">
              Cancel
            </button>
            <button type="submit" 
                    class="px-4 py-2 bg-blue-600 text-white rounded-lg hover:bg-blue-700 transition-colors">
              <i data-lucide="save" class="w-4 h-4 mr-2 inline"></i>
              Adjust Stock
            </button>
          </div>
        </div>
      </form>
    </div>
  </div>

  <script>
    let currentDishId = null;
    
    function openAdjustModal(dishId, dishName, currentStock) {
      currentDishId = dishId;
      document.getElementById('dishInfo').textContent = dishName;
      document.getElementById('currentStock').textContent = currentStock;
      document.getElementById('adjustForm').action = `/admin/dishes/${dishId}/inventory/adjust`;
      document.getElementById('adjustModal').classList.remove('hidden');
      document.getElementById('adjustModal').classList.add('flex');
      document.getElementById('changeAmount').focus();
      
      // Reset form
      document.getElementById('adjustForm').reset();
    }
    
    function closeAdjustModal() {
      document.getElementById('adjustModal').classList.add('hidden');
      document.getElementById('adjustModal').classList.remove('flex');
      currentDishId = null;
    }
    
    // Close modal on escape key
    document.addEventListener('keydown', function(e) {
      if (e.key === 'Escape' && !document.getElementById('adjustModal').classList.contains('hidden')) {
        closeAdjustModal();
      }
    });
    
    // Close modal when clicking outside
    document.getElementById('adjustModal').addEventListener('click', function(e) {
      if (e.target === this) {
        closeAdjustModal();
      }
    });
    
    // Handle form submission
    document.getElementById('adjustForm').addEventListener('submit', function(e) {
      const changeAmount = parseInt(document.getElementById('changeAmount').value);
      const currentStock = parseInt(document.getElementById('currentStock').textContent);
      const newStock = currentStock + changeAmount;
      
      if (newStock < 0) {
        e.preventDefault();
        alert('This adjustment would result in negative stock (' + newStock + '). Please adjust the amount.');
        return;
      }
      
      if (changeAmount === 0) {
        e.preventDefault();
        alert('Change amount cannot be zero.');
        return;
      }
      
      // Disable submit button to prevent double submission
      const submitBtn = this.querySelector('button[type="submit"]');
      submitBtn.disabled = true;
      submitBtn.innerHTML = '<i data-lucide="loader-2" class="w-4 h-4 mr-2 inline animate-spin"></i> Adjusting...';
    });
  </script>

  {{-- Dropdown Toggle Script --}}
  <script>
    function toggleDropdown(dishId) {
      // Close all other dropdowns first
      document.querySelectorAll('[id^="dropdown-"]').forEach(dropdown => {
        if (dropdown.id !== `dropdown-${dishId}`) {
          dropdown.classList.add('hidden');
        }
      });
      
      // Toggle the current dropdown
      const dropdown = document.getElementById(`dropdown-${dishId}`);
      dropdown.classList.toggle('hidden');
    }
    
    // Close dropdowns when clicking outside
    document.addEventListener('click', function(e) {
      if (!e.target.closest('[id^="dropdown-"]') && !e.target.closest('button[onclick*="toggleDropdown"]')) {
        document.querySelectorAll('[id^="dropdown-"]').forEach(dropdown => {
          dropdown.classList.add('hidden');
        });
      }
    });
    
    // Close dropdowns on escape key
    document.addEventListener('keydown', function(e) {
      if (e.key === 'Escape') {
        document.querySelectorAll('[id^="dropdown-"]').forEach(dropdown => {
          dropdown.classList.add('hidden');
        });
      }
    });
  </script>
</x-admin-layout>
