<x-admin-layout>
  <x-slot name="header">
    <div>
      <h2 class="font-semibold text-xl">Trashed Dishes</h2>
      <x-admin.breadcrumbs :items="[[ 'label' => 'Dishes', 'url' => route('admin.dishes.index') ], [ 'label' => 'Trash' ]]" />
    </div>
  </x-slot>
  <div class="py-6">
    <div class="max-w-5xl mx-auto px-4">
      @if(session('status'))
        <div class="mb-4 rounded border border-emerald-200 bg-emerald-50 text-emerald-800 px-4 py-2">{{ session('status') }}</div>
      @endif
      <div class="overflow-hidden rounded-lg border border-white/30 dark:border-slate-700/50 bg-white/80 dark:bg-slate-800/80">
        <div class="overflow-x-auto">
          <table class="min-w-full text-sm">
            <thead class="bg-gray-50/90 dark:bg-slate-900/70 backdrop-blur">
              <tr>
                <th class="px-4 py-3">Name</th>
                <th class="px-4 py-3">Deleted</th>
                <th class="px-4 py-3 text-right">Actions</th>
              </tr>
            </thead>
            <tbody class="divide-y divide-gray-100/60 dark:divide-slate-700/50">
              @forelse($dishes as $dish)
                <tr>
                  <td class="px-4 py-3">{{ $dish->name }}</td>
                  <td class="px-4 py-3">{{ $dish->deleted_at?->diffForHumans() }}</td>
                  <td class="px-4 py-3 text-right space-x-2">
                    <form action="{{ route('admin.dishes.restore', $dish->id) }}" method="POST" class="inline">
                      @csrf
                      <button class="inline-flex items-center gap-1 px-3 py-1.5 border border-emerald-300 text-emerald-700 rounded hover:bg-emerald-50 dark:hover:bg-emerald-900/20"><i data-lucide="rotate-ccw" class="w-4 h-4"></i> Restore</button>
                    </form>
                    <form action="{{ route('admin.dishes.force-delete', $dish->id) }}" method="POST" class="inline" onsubmit="return confirm('Permanently delete this dish?')">
                      @csrf
                      @method('DELETE')
                      <button class="inline-flex items-center gap-1 px-3 py-1.5 border border-red-300 text-red-700 rounded hover:bg-red-50 dark:hover:bg-red-900/20"><i data-lucide="trash-2" class="w-4 h-4"></i> Force Delete</button>
                    </form>
                  </td>
                </tr>
              @empty
                <tr><td colspan="3" class="px-4 py-10 text-center text-gray-500">Trash is empty.</td></tr>
              @endforelse
            </tbody>
          </table>
        </div>
      </div>
      <div class="mt-4">{{ $dishes->links() }}</div>
      <div class="mt-6"><a href="{{ route('admin.dishes.index') }}" class="inline-flex items-center gap-2 px-4 py-2 border rounded dark:border-slate-600"><i data-lucide="arrow-left" class="w-4 h-4"></i> Back</a></div>
    </div>
  </div>
</x-admin-layout>
