<x-admin-layout>
  <x-slot name="header">
    <div>
      <h2 class="font-semibold text-xl">Availability – Pivot View</h2>
      <x-admin.breadcrumbs :items="[['label' => 'Inventory', 'url' => route('admin.inventory.index')], ['label' => 'Availability Pivot']]" />
    </div>
  </x-slot>

  <div class="max-w-7xl mx-auto p-4 space-y-6">
    <div class="bg-white/80 dark:bg-slate-800/80 rounded-lg border border-white/30 dark:border-slate-700/50 p-4">
      <form method="GET" action="{{ route('admin.inventory.availability.pivot') }}" class="flex flex-wrap items-end gap-3">
        <div>
          <label class="block text-sm mb-1">Search dishes</label>
          <input type="text" name="search" value="{{ $request->search }}" class="border rounded px-3 py-2 bg-white dark:bg-slate-900" placeholder="Name" />
        </div>
        <div>
          <label class="block text-sm mb-1">Per page</label>
          <select name="per_page" class="border rounded px-3 py-2 bg-white dark:bg-slate-900">
            @foreach([25,50,100,200] as $n)
              <option value="{{ $n }}" {{ (int)($request->per_page ?? 50) === $n ? 'selected' : '' }}>{{ $n }}</option>
            @endforeach
          </select>
        </div>
        <div>
          <button class="px-4 py-2 bg-blue-600 text-white rounded">Apply</button>
          <a href="{{ route('admin.inventory.availability.pivot') }}" class="px-4 py-2 border rounded">Clear</a>
          <a href="{{ route('admin.inventory.availability') }}" class="px-4 py-2 border rounded">Standard View</a>
        </div>
      </form>
    </div>

    <div class="bg-white/80 dark:bg-slate-800/80 rounded-lg border border-white/30 dark:border-slate-700/50 overflow-auto">
      <table class="min-w-full text-sm">
        <thead class="bg-gray-50/90 dark:bg-slate-900/70 backdrop-blur text-left">
          <tr>
            <th class="px-4 py-3">Dish</th>
            @foreach($locations as $loc)
              <th class="px-4 py-3 whitespace-nowrap">{{ $loc->name }}</th>
            @endforeach
            <th class="px-4 py-3">Total</th>
          </tr>
        </thead>
        <tbody class="divide-y divide-gray-200 dark:divide-slate-700">
          @forelse($dishes as $dish)
            @php $rowTotal = 0; @endphp
            <tr>
              <td class="px-4 py-3">
                <div class="font-medium">{{ $dish->name }}</div>
                <div class="text-xs text-gray-500">ID: {{ $dish->id }}</div>
              </td>
              @foreach($locations as $loc)
                @php $qty = (int)($matrix[$dish->id][$loc->id] ?? 0); $rowTotal += $qty; @endphp
                <td class="px-4 py-3">
                  <span class="inline-flex items-center px-2 py-0.5 rounded text-xs font-medium {{ $qty <= $dish->low_stock_threshold ? 'bg-red-100 text-red-800 dark:bg-red-900/50 dark:text-red-300' : 'bg-green-100 text-green-800 dark:bg-green-900/50 dark:text-green-300' }}">{{ $qty }}</span>
                </td>
              @endforeach
              <td class="px-4 py-3 font-semibold">{{ $rowTotal }}</td>
            </tr>
          @empty
            <tr>
              <td colspan="{{ 2 + $locations->count() }}" class="px-4 py-6 text-center text-gray-500">No dishes</td>
            </tr>
          @endforelse
        </tbody>
      </table>
      <div class="p-3">{{ $dishes->links() }}</div>
    </div>
  </div>
</x-admin-layout>
