<x-admin-layout>
  <x-slot name="header">
    <div>
      <h2 class="font-semibold text-xl">Per-Location Availability</h2>
      <x-admin.breadcrumbs :items="[['label' => 'Inventory', 'url' => route('admin.inventory.index')], ['label' => 'Availability']]" />
    </div>
  </x-slot>

  <div class="max-w-7xl mx-auto p-4 space-y-6">
    @if(isset($grandTotals))
    <div class="bg-white/80 dark:bg-slate-800/80 rounded-lg border border-white/30 dark:border-slate-700/50 p-4">
      <div class="flex items-center justify-between">
        <div class="text-sm font-semibold">Grand totals (all pages, current filters)</div>
        <div class="space-x-6 text-sm">
          <span><span class="text-gray-500">Qty:</span> <span class="font-semibold">{{ (int)($grandTotals->qty ?? 0) }}</span></span>
          <span><span class="text-gray-500">Value +:</span> <span class="font-semibold">₦{{ number_format((float)($grandTotals->pos_value ?? 0), 2) }}</span></span>
          <span><span class="text-gray-500">Value -:</span> <span class="font-semibold">₦{{ number_format((float)($grandTotals->neg_value ?? 0), 2) }}</span></span>
          <span><span class="text-gray-500">Current valuation:</span> <span class="font-semibold">₦{{ number_format((float)($currentValuation ?? 0), 2) }}</span></span>
        </div>
      </div>
    </div>
    @endif
    @php
      // Build chart data: sum qty per location from current page rows
      $chartByLocation = [];
      foreach ($rows as $r) {
        $lname = $r->location_name ?? 'Unassigned';
        $chartByLocation[$lname] = ($chartByLocation[$lname] ?? 0) + (int)$r->qty;
      }
      $chartMax = max(1, collect($chartByLocation)->max() ?? 1);
    @endphp
    @if(count($chartByLocation))
    <div class="bg-white/80 dark:bg-slate-800/80 rounded-lg border border-white/30 dark:border-slate-700/50 p-4">
      <div class="flex items-center justify-between mb-3">
        <h3 class="text-lg font-semibold">Totals by Location (current page)</h3>
        <span class="text-xs text-gray-500">Simple inline chart</span>
      </div>
      <div class="overflow-x-auto">
        <div class="min-w-[600px]">
          <svg viewBox="0 0 600 {{ 30 * count($chartByLocation) }}" width="100%" height="{{ 30 * count($chartByLocation) }}" aria-label="Totals by Location">
            @php $i=0; @endphp
            @foreach($chartByLocation as $locName => $total)
              @php $barWidth = $chartMax > 0 ? (int)( ($total / $chartMax) * 520 ) : 0; @endphp
              <g transform="translate(60, {{ 30 * $i + 5 }})">
                <rect x="0" y="0" width="{{ $barWidth }}" height="20" fill="#0ea5e9" rx="4" />
                <text x="-8" y="14" text-anchor="end" fill="#64748b" font-size="12">{{ Str::limit($locName, 14) }}</text>
                <text x="{{ $barWidth + 6 }}" y="14" fill="#334155" font-size="12">{{ $total }}</text>
              </g>
              @php $i++; @endphp
            @endforeach
          </svg>
        </div>
      </div>
    </div>
    @endif
    <div class="bg-white/80 dark:bg-slate-800/80 rounded-lg border border-white/30 dark:border-slate-700/50 p-4">
      <form method="GET" action="{{ route('admin.inventory.availability') }}" class="grid grid-cols-1 md:grid-cols-3 gap-3">
        <div>
          <label class="block text-sm mb-1">Search</label>
          <input type="text" name="search" value="{{ $request->search }}" placeholder="Dish or location"
                 class="w-full border rounded px-3 py-2 bg-white dark:bg-slate-900" />
        </div>
        <div>
          <label class="block text-sm mb-1">Location</label>
          <select name="location_id" class="w-full border rounded px-3 py-2 bg-white dark:bg-slate-900">
            <option value="">All locations</option>
            @foreach($locations as $loc)
              <option value="{{ $loc->id }}" {{ (string)$request->location_id === (string)$loc->id ? 'selected' : '' }}>{{ $loc->name }}</option>
            @endforeach
          </select>
        </div>
        <div class="flex items-end gap-2">
          <button class="px-4 py-2 bg-blue-600 text-white rounded">Apply</button>
          <a href="{{ route('admin.inventory.availability') }}" class="px-4 py-2 border rounded">Clear</a>
          <a href="{{ route('admin.inventory.availability.export', request()->query()) }}" class="px-4 py-2 bg-emerald-600 text-white rounded">Export CSV</a>
        </div>
      </form>
    </div>

    @php
      // Build totals by dish from the current page rows (UI-level). For full totals, export CSV.
      $totalsByDish = [];
      $pageTotalQty = 0; $pageTotalValue = 0.0;
      foreach ($rows as $r) {
        $key = $r->dish_id.'|'.$r->dish_name;
        if (!isset($totalsByDish[$key])) {
          $totalsByDish[$key] = 0;
        }
        $totalsByDish[$key] += (int)$r->qty;
        $pageTotalQty += (int)$r->qty;
        $pageTotalValue += max(0, (int)$r->qty) * (float)$r->price;
      }
    @endphp

    <div class="bg-white/80 dark:bg-slate-800/80 rounded-lg border border-white/30 dark:border-slate-700/50 overflow-hidden">
      <div class="overflow-x-auto">
        <table class="min-w-full text-sm">
          <thead class="bg-gray-50/90 dark:bg-slate-900/70 backdrop-blur text-left text-gray-700 dark:text-slate-300">
            <tr>
              <th class="px-6 py-3">Dish</th>
              <th class="px-6 py-3">Location</th>
              <th class="px-6 py-3">Qty</th>
              <th class="px-6 py-3">Threshold</th>
              <th class="px-6 py-3">Value</th>
            </tr>
          </thead>
          <tbody class="divide-y divide-gray-200 dark:divide-slate-700">
            @php $currentDishKey = null; @endphp
            @forelse($rows as $row)
              @php $dishKey = $row->dish_id.'|'.$row->dish_name; @endphp
              @if($currentDishKey !== $dishKey)
                @php $currentDishKey = $dishKey; @endphp
                <tr class="bg-gray-50/60 dark:bg-slate-900/40">
                  <td class="px-6 py-2 font-semibold" colspan="5">
                    <div class="flex items-center justify-between">
                      <div>
                        {{ $row->dish_name }} — Total across locations (this page):
                        <span class="ml-1 inline-flex items-center px-2 py-0.5 rounded text-xs font-medium bg-slate-100 dark:bg-slate-800">
                          {{ (int)($totalsByDish[$dishKey] ?? 0) }}
                        </span>
                        <span class="ml-3 text-xs text-gray-500">
                          All locations total:
                          <span class="font-semibold js-dish-total-all" data-dish-id="{{ $row->dish_id }}">…</span>
                        </span>
                      </div>
                      <div class="hidden md:block">
                        <svg class="js-sparkline" data-dish-id="{{ $row->dish_id }}" width="160" height="28" viewBox="0 0 160 28" aria-label="Recent movements sparkline"></svg>
                      </div>
                    </div>
                  </td>
                </tr>
              @endif
              <tr class="hover:bg-gray-50/50 dark:hover:bg-slate-700/50">
                <td class="px-6 py-3">
                  <div class="text-xs text-gray-500">ID: {{ $row->dish_id }}</div>
                </td>
                <td class="px-6 py-3">{{ $row->location_name ?? '—' }}</td>
                <td class="px-6 py-3">
                  <span class="inline-flex items-center px-2 py-0.5 rounded text-xs font-medium
                    {{ $row->qty <= $row->low_stock_threshold ? 'bg-red-100 text-red-800 dark:bg-red-900/50 dark:text-red-300' : 'bg-green-100 text-green-800 dark:bg-green-900/50 dark:text-green-300' }}">
                    {{ (int)$row->qty }}
                  </span>
                </td>
                <td class="px-6 py-3">{{ (int)$row->low_stock_threshold }}</td>
                <td class="px-6 py-3">₦{{ number_format(max(0, (int)$row->qty) * (float)$row->price, 2) }}</td>
              </tr>
            @empty
              <tr>
                <td colspan="5" class="px-6 py-8 text-center text-gray-500">No data</td>
              </tr>
            @endforelse
          </tbody>
        </table>
      </div>
      <div class="border-t border-gray-200 dark:border-slate-700">
        <div class="flex items-center justify-between px-6 py-3 text-sm">
          <div class="text-gray-600 dark:text-slate-300">Page totals</div>
          <div class="space-x-6">
            <span><span class="text-gray-500">Qty:</span> <span class="font-semibold">{{ (int)$pageTotalQty }}</span></span>
            <span><span class="text-gray-500">Value:</span> <span class="font-semibold">₦{{ number_format($pageTotalValue, 2) }}</span></span>
          </div>
        </div>
      </div>
      <div class="p-3">{{ $rows->links() }}</div>
    </div>
  </div>

  @push('scripts')
  <script nonce="{{ $cspNonce ?? '' }}">
    (function(){
      try {
        // Collect unique dish IDs present
        const totalEls = Array.from(document.querySelectorAll('.js-dish-total-all'));
        const ids = Array.from(new Set(totalEls.map(el => el.getAttribute('data-dish-id')).filter(Boolean)));
        if (ids.length) {
          const url = new URL("{{ route('admin.inventory.availability.totals') }}", window.location.origin);
          ids.forEach(id => url.searchParams.append('dish_ids[]', id));
          fetch(url.toString(), { headers: { 'Accept': 'application/json' } })
            .then(r => r.ok ? r.json() : Promise.reject())
            .then(data => {
              (data.totals || []).forEach(item => {
                const els = document.querySelectorAll(`.js-dish-total-all[data-dish-id="${item.dish_id}"]`);
                els.forEach(el => el.textContent = item.qty);
              });
            }).catch(() => {});
        }

        // Draw sparkline per dish: last N movements change values
        const sparkEls = Array.from(document.querySelectorAll('.js-sparkline'));
        const draw = (el, series) => {
          const w = el.viewBox.baseVal.width || 160;
          const h = el.viewBox.baseVal.height || 28;
          const n = series.length;
          if (!n) return;
          const min = Math.min(0, ...series);
          const max = Math.max(0, ...series);
          const span = (max - min) || 1;
          const step = w / Math.max(1, n - 1);
          const mid = (0 - min) / span * (h - 6) + 3; // baseline
          let d = '';
          series.forEach((v, i) => {
            const x = i * step;
            const y = h - ( (v - min) / span * (h - 6) + 3 );
            d += (i ? ' L ' : 'M ') + x.toFixed(2) + ' ' + y.toFixed(2);
          });
          el.innerHTML = '';
          const axis = document.createElementNS('http://www.w3.org/2000/svg', 'line');
          axis.setAttribute('x1', '0'); axis.setAttribute('x2', String(w));
          const ay = h - mid; axis.setAttribute('y1', String(ay)); axis.setAttribute('y2', String(ay));
          axis.setAttribute('stroke', '#94a3b8'); axis.setAttribute('stroke-width', '1'); axis.setAttribute('opacity', '0.5');
          el.appendChild(axis);
          const path = document.createElementNS('http://www.w3.org/2000/svg', 'path');
          path.setAttribute('d', d);
          path.setAttribute('fill', 'none');
          path.setAttribute('stroke', '#0ea5e9');
          path.setAttribute('stroke-width', '2');
          el.appendChild(path);
        };
        sparkEls.forEach(el => {
          const id = el.getAttribute('data-dish-id');
          const url = new URL("{{ route('admin.inventory.availability.sparkline') }}", window.location.origin);
          url.searchParams.set('dish_id', id);
          url.searchParams.set('n', '20');
          fetch(url.toString(), { headers: { 'Accept': 'application/json' } })
            .then(r => r.ok ? r.json() : Promise.reject())
            .then(data => draw(el, data.series || []))
            .catch(() => {});
        });
      } catch (e) {}
    })();
  </script>
  @endpush
</x-admin-layout>
