<x-admin-layout>
  <x-slot name="header">
    <div>
      <h2 class="font-semibold text-xl">Inventory – {{ $dish->name }}</h2>
      <x-admin.breadcrumbs :items="[[ 'label' => 'Dishes', 'url' => route('admin.dishes.index') ], [ 'label' => 'Inventory' ]]" />
    </div>
  </x-slot>

  <div class="max-w-5xl mx-auto p-4">
    @if ($errors->any())
      <div class="mb-4 rounded border border-red-200 bg-red-50 text-red-800 px-4 py-2">
        <div class="font-medium">Please fix the errors below</div>
        <ul class="list-disc ms-5 mt-1">
          @foreach ($errors->all() as $error)
            <li>{{ $error }}</li>
          @endforeach
        </ul>
      </div>
    @endif
    @if(session('status'))
      <div class="mb-4 rounded border border-emerald-200 bg-emerald-50 text-emerald-800 px-4 py-2">{{ session('status') }}</div>
    @endif

    <div class="mb-6 bg-white/80 dark:bg-slate-800/80 rounded-lg border border-white/30 dark:border-slate-700/50 p-4">
      <form method="POST" action="{{ route('admin.dishes.inventory.adjust', $dish) }}" class="grid sm:grid-cols-3 gap-3">
        @csrf
        <div>
          <label class="block text-sm font-medium mb-1">Change</label>
          <input type="number" name="change" step="1" class="w-full border rounded px-3 py-2 dark:bg-slate-900 dark:border-slate-700" placeholder="e.g. 10 or -5" required>
        </div>
        <div>
          <label class="block text-sm font-medium mb-1">Reason</label>
          <input type="text" name="reason" class="w-full border rounded px-3 py-2 dark:bg-slate-900 dark:border-slate-700" placeholder="production, spoilage, correction">
        </div>
        <div>
          <label class="block text-sm font-medium mb-1">Note</label>
          <input type="text" name="note" class="w-full border rounded px-3 py-2 dark:bg-slate-900 dark:border-slate-700" placeholder="optional">
        </div>
        <div class="sm:col-span-3">
          <button class="inline-flex items-center gap-2 px-4 py-2 bg-indigo-600 text-white rounded hover:bg-indigo-700"><i data-lucide="save" class="w-4 h-4"></i>Adjust Stock</button>
          <a href="{{ route('admin.dishes.index') }}" class="ms-2 px-4 py-2 border rounded dark:border-slate-600">Back</a>
        </div>
      </form>
    </div>

    <div class="overflow-hidden rounded-lg border border-white/30 dark:border-slate-700/50 bg-white/80 dark:bg-slate-800/80">
      <div class="overflow-x-auto">
        <table class="min-w-full text-sm">
          <thead class="bg-gray-50/90 dark:bg-slate-900/70 backdrop-blur text-left text-gray-700 dark:text-slate-300">
            <tr>
              <th class="px-4 py-3">Date</th>
              <th class="px-4 py-3">Change</th>
              <th class="px-4 py-3">Reason</th>
              <th class="px-4 py-3">User</th>
              <th class="px-4 py-3">Note</th>
            </tr>
          </thead>
          <tbody class="divide-y divide-gray-100/60 dark:divide-slate-700/50">
            @forelse($movements as $m)
            <tr>
              <td class="px-4 py-3">{{ $m->created_at->format('Y-m-d H:i') }}</td>
              <td class="px-4 py-3">{{ $m->change > 0 ? '+' : '' }}{{ $m->change }}</td>
              <td class="px-4 py-3">{{ $m->reason }}</td>
              <td class="px-4 py-3">{{ optional($m->user)->name ?? '-' }}</td>
              <td class="px-4 py-3">{{ $m->note }}</td>
            </tr>
            @empty
            <tr>
              <td colspan="5" class="px-4 py-6 text-center text-gray-500">No movements yet.</td>
            </tr>
            @endforelse
          </tbody>
        </table>
      </div>
      <div class="p-3">{{ $movements->links() }}</div>
    </div>
  </div>
</x-admin-layout>
