<x-admin-layout>
    <x-slot name="header">
        <div>
            <h2 class="font-semibold text-xl">Inventory Movements</h2>
            <x-admin.breadcrumbs :items="[['label' => 'Inventory', 'url' => route('admin.inventory.index')], ['label' => 'Movements']]" />
        </div>
    </x-slot>

    <div class="max-w-7xl mx-auto p-4">
        {{-- Filters Section --}}
        <div class="bg-white/80 dark:bg-slate-800/80 rounded-lg border border-white/30 dark:border-slate-700/50 p-6 mb-6">
            <form id="filters-form" method="GET" action="{{ route('admin.inventory.movements') }}" class="space-y-4">
                <div class="flex items-center justify-between mb-4">
                    <h3 class="text-lg font-semibold text-gray-900 dark:text-white">Filters</h3>
                    <div class="flex space-x-2">
                        <button type="submit" class="inline-flex items-center px-4 py-2 bg-blue-600 text-white rounded-lg hover:bg-blue-700 transition-colors">
                            <i data-lucide="search" class="w-4 h-4 mr-2"></i>
                            Apply Filters
                        </button>
                        <a href="{{ route('admin.inventory.movements') }}" class="inline-flex items-center px-4 py-2 border border-gray-300 dark:border-gray-600 rounded-lg hover:bg-gray-50 dark:hover:bg-slate-700 transition-colors">
                            <i data-lucide="x" class="w-4 h-4 mr-2"></i>
                            Clear
                        </a>
                    </div>
                </div>

                <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 xl:grid-cols-4 gap-4">
                    {{-- Search --}}
                    <div>
                        <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-1">Search</label>
                        <input type="text" name="search" value="{{ $request->search }}" 
                               placeholder="Dish name, reason, or note..." 
                               class="w-full border border-gray-300 dark:border-gray-600 rounded-lg px-3 py-2 bg-white dark:bg-slate-900 text-gray-900 dark:text-white">
                    </div>

                    {{-- Dish Filter --}}
                    <div>
                        <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-1">Dish</label>
                        <select name="dish_id" class="w-full border border-gray-300 dark:border-gray-600 rounded-lg px-3 py-2 bg-white dark:bg-slate-900 text-gray-900 dark:text-white">
                            <option value="">All Dishes</option>
                            @foreach($dishes as $dish)
                                <option value="{{ $dish->id }}" {{ $request->dish_id == $dish->id ? 'selected' : '' }}>
                                    {{ $dish->name }}
                                </option>
                            @endforeach
                        </select>
                    </div>

                    {{-- Location Filter --}}
                    <div>
                        <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-1">Location</label>
                        <select name="location_id" class="w-full border border-gray-300 dark:border-gray-600 rounded-lg px-3 py-2 bg-white dark:bg-slate-900 text-gray-900 dark:text-white">
                            <option value="">All Locations</option>
                            @foreach(($locations ?? []) as $loc)
                                <option value="{{ $loc->id }}" {{ $request->location_id == $loc->id ? 'selected' : '' }}>
                                    {{ $loc->name }}
                                </option>
                            @endforeach
                        </select>
                    </div>

                    {{-- Reason Filter --}}
                    <div>
                        <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-1">Reason</label>
                        <select name="reason" class="w-full border border-gray-300 dark:border-gray-600 rounded-lg px-3 py-2 bg-white dark:bg-slate-900 text-gray-900 dark:text-white">
                            <option value="">All Reasons</option>
                            @foreach($reasons as $key => $label)
                                <option value="{{ $key }}" {{ $request->reason == $key ? 'selected' : '' }}>
                                    {{ $label }}
                                </option>
                            @endforeach
                        </select>
                    </div>

                    {{-- User Filter --}}
                    <div>
                        <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-1">User</label>
                        <select name="user_id" class="w-full border border-gray-300 dark:border-gray-600 rounded-lg px-3 py-2 bg-white dark:bg-slate-900 text-gray-900 dark:text-white">
                            <option value="">All Users</option>
                            @foreach($users as $user)
                                <option value="{{ $user->id }}" {{ $request->user_id == $user->id ? 'selected' : '' }}>
                                    {{ $user->name }}
                                </option>
                            @endforeach
                        </select>
                    </div>

                    {{-- Date From --}}
                    <div>
                        <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-1">Date From</label>
                        <input type="date" name="date_from" value="{{ $request->date_from }}" 
                               class="w-full border border-gray-300 dark:border-gray-600 rounded-lg px-3 py-2 bg-white dark:bg-slate-900 text-gray-900 dark:text-white">
                    </div>

                    {{-- Date To --}}
                    <div>
                        <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-1">Date To</label>
                        <input type="date" name="date_to" value="{{ $request->date_to }}" 
                               class="w-full border border-gray-300 dark:border-gray-600 rounded-lg px-3 py-2 bg-white dark:bg-slate-900 text-gray-900 dark:text-white">
                    </div>

                    {{-- Order ID --}}
                    <div>
                        <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-1">Order ID</label>
                        <input type="number" name="order_id" value="{{ $request->order_id }}" 
                               placeholder="Enter order ID..." 
                               class="w-full border border-gray-300 dark:border-gray-600 rounded-lg px-3 py-2 bg-white dark:bg-slate-900 text-gray-900 dark:text-white">
                    </div>
                </div>
            </form>
        </div>

        {{-- Results Summary --}}
        <div class="bg-white/80 dark:bg-slate-800/80 rounded-lg border border-white/30 dark:border-slate-700/50 p-4 mb-6">
            <div class="flex items-center justify-between">
                <div class="flex items-center space-x-4">
                    <div class="text-sm text-gray-600 dark:text-gray-400">
                        Showing {{ $movements->firstItem() ?? 0 }} to {{ $movements->lastItem() ?? 0 }} of {{ $movements->total() }} movements
                        @if($movements->hasPages())
                            (Page {{ $movements->currentPage() }} of {{ $movements->lastPage() }})
                        @endif
                    </div>
                    <div class="flex items-center space-x-2">
                        <label class="text-sm text-gray-600 dark:text-gray-400">Per page:</label>
                        <select name="per_page" onchange="this.form.submit()" form="filters-form"
                                class="border border-gray-300 dark:border-gray-600 rounded px-2 py-1 text-sm bg-white dark:bg-slate-900 text-gray-900 dark:text-white">
                            @foreach([10, 20, 50, 100] as $size)
                                <option value="{{ $size }}" {{ request('per_page', 20) == $size ? 'selected' : '' }}>
                                    {{ $size }}
                                </option>
                            @endforeach
                        </select>
                    </div>
                </div>
                <div class="flex space-x-2">
                    <a href="{{ route('admin.inventory.movements.export', request()->query()) }}" 
                       class="inline-flex items-center px-3 py-1 bg-green-600 text-white rounded-md hover:bg-green-700 transition-colors text-sm">
                        <i data-lucide="download" class="w-4 h-4 mr-1"></i>
                        Export CSV
                    </a>
                    <a href="{{ route('admin.inventory.transfer.form') }}"
                       class="inline-flex items-center px-3 py-1 bg-amber-600 text-white rounded-md hover:bg-amber-700 transition-colors text-sm">
                        <i data-lucide="swap-horizontal" class="w-4 h-4 mr-1"></i>
                        Transfer Stock
                    </a>
                </div>
            </div>
        </div>

        {{-- Movements Table --}}
        <div class="bg-white/80 dark:bg-slate-800/80 rounded-lg border border-white/30 dark:border-slate-700/50 overflow-hidden">
            <div class="overflow-x-auto">
                <table class="min-w-full text-sm">
                    <thead class="bg-gray-50/90 dark:bg-slate-900/70 backdrop-blur text-left text-gray-700 dark:text-slate-300">
                        <tr>
                            <th class="px-6 py-3 font-medium">Date & Time</th>
                            <th class="px-6 py-3 font-medium">Dish</th>
                            <th class="px-6 py-3 font-medium">Location</th>
                            <th class="px-6 py-3 font-medium">Change</th>
                            <th class="px-6 py-3 font-medium">Reason</th>
                            <th class="px-6 py-3 font-medium">User</th>
                            <th class="px-6 py-3 font-medium">Order</th>
                            <th class="px-6 py-3 font-medium">Note</th>
                            <th class="px-6 py-3 font-medium">Actions</th>
                        </tr>
                    </thead>
                    <tbody class="divide-y divide-gray-200 dark:divide-slate-700">
                        @forelse($movements as $movement)
                            <tr class="hover:bg-gray-50/50 dark:hover:bg-slate-700/50">
                                <td class="px-6 py-4">
                                    <div class="text-gray-900 dark:text-white font-medium">
                                        {{ $movement->created_at->format('M j, Y') }}
                                    </div>
                                    <div class="text-gray-500 dark:text-gray-400 text-xs">
                                        {{ $movement->created_at->format('g:i A') }}
                                    </div>
                                </td>
                                <td class="px-6 py-4">
                                    <div class="font-medium text-gray-900 dark:text-white">
                                        {{ $movement->dish->name ?? 'Unknown Dish' }}
                                    </div>
                                    <div class="text-gray-500 dark:text-gray-400 text-xs">
                                        ID: {{ $movement->dish_id }}
                                    </div>
                                </td>
                                <td class="px-6 py-4 text-gray-900 dark:text-white">
                                    {{ $movement->location->name ?? '—' }}
                                </td>
                                <td class="px-6 py-4">
                                    <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium
                                        {{ $movement->change > 0 ? 'bg-green-100 text-green-800 dark:bg-green-900/50 dark:text-green-300' : 'bg-red-100 text-red-800 dark:bg-red-900/50 dark:text-red-300' }}">
                                        {{ $movement->change > 0 ? '+' : '' }}{{ $movement->change }}
                                    </span>
                                </td>
                                <td class="px-6 py-4">
                                    <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium 
                                        @switch($movement->reason)
                                            @case('sale')
                                                bg-blue-100 text-blue-800 dark:bg-blue-900/50 dark:text-blue-300
                                                @break
                                            @case('adjustment')
                                                bg-yellow-100 text-yellow-800 dark:bg-yellow-900/50 dark:text-yellow-300
                                                @break
                                            @case('correction')
                                                bg-purple-100 text-purple-800 dark:bg-purple-900/50 dark:text-purple-300
                                                @break
                                            @case('spoilage')
                                                bg-red-100 text-red-800 dark:bg-red-900/50 dark:text-red-300
                                                @break
                                            @default
                                                bg-gray-100 text-gray-800 dark:bg-gray-700 dark:text-gray-300
                                        @endswitch
                                    ">
                                        {{ ucfirst($movement->reason) }}
                                    </span>
                                </td>
                                <td class="px-6 py-4 text-gray-900 dark:text-white">
                                    {{ $movement->user->name ?? 'System' }}
                                </td>
                                <td class="px-6 py-4">
                                    @if($movement->order_id)
                                        <a href="{{ route('admin.orders.show', $movement->order_id) }}" 
                                           class="text-blue-600 dark:text-blue-400 hover:text-blue-800 dark:hover:text-blue-300 font-medium">
                                            #{{ $movement->order_id }}
                                        </a>
                                    @else
                                        <span class="text-gray-400">—</span>
                                    @endif
                                </td>
                                <td class="px-6 py-4 text-gray-500 dark:text-gray-400">
                                    @if($movement->note)
                                        <span title="{{ $movement->note }}">
                                            {{ Str::limit($movement->note, 30) }}
                                        </span>
                                    @else
                                        —
                                    @endif
                                </td>
                                <td class="px-6 py-4">
                                    <div class="flex space-x-2">
                                        <a href="{{ route('admin.dishes.inventory.history', $movement->dish_id) }}" 
                                           class="text-blue-600 dark:text-blue-400 hover:text-blue-800 dark:hover:text-blue-300 text-xs" 
                                           title="View dish history">
                                            <i data-lucide="history" class="w-4 h-4"></i>
                                        </a>
                                        @if($movement->order_id)
                                            <a href="{{ route('admin.orders.show', $movement->order_id) }}" 
                                               class="text-green-600 dark:text-green-400 hover:text-green-800 dark:hover:text-green-300 text-xs" 
                                               title="View order">
                                                <i data-lucide="external-link" class="w-4 h-4"></i>
                                            </a>
                                        @endif
                                    </div>
                                </td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="8" class="px-6 py-12 text-center text-gray-500 dark:text-gray-400">
                                    <div class="flex flex-col items-center">
                                        <i data-lucide="search" class="w-12 h-12 text-gray-300 dark:text-gray-600 mb-4"></i>
                                        <p class="text-lg font-medium mb-2">No movements found</p>
                                        <p class="text-sm">Try adjusting your filters or search criteria</p>
                                    </div>
                                </td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>

            {{-- Pagination --}}
            @if($movements->hasPages())
                <div class="border-t border-gray-200 dark:border-slate-700 px-6 py-3">
                    {{ $movements->links() }}
                </div>
            @endif
        </div>

        {{-- Quick Actions --}}
        <div class="mt-6 flex justify-between items-center">
            <div class="flex space-x-3">
                <a href="{{ route('admin.inventory.index') }}" 
                   class="inline-flex items-center px-4 py-2 border border-gray-300 dark:border-gray-600 rounded-lg hover:bg-gray-50 dark:hover:bg-slate-700 transition-colors">
                    <i data-lucide="arrow-left" class="w-4 h-4 mr-2"></i>
                    Back to Dashboard
                </a>
            </div>
            <div class="text-sm text-gray-500 dark:text-gray-400">
                Last updated: {{ now()->format('M j, Y g:i A') }}
            </div>
        </div>
    </div>
</x-admin-layout>