<x-admin-layout>
  <x-slot name="header">
    <div>
      <h2 class="font-semibold text-xl">Transfer Stock</h2>
      <x-admin.breadcrumbs :items="[['label' => 'Inventory', 'url' => route('admin.inventory.index')], ['label' => 'Transfer']]" />
    </div>
  </x-slot>

  <div class="max-w-3xl mx-auto p-4">
    @if(($locations->count() ?? 0) < 2)
      <div class="mb-4 rounded border border-amber-200 bg-amber-50 text-amber-900 px-4 py-2">
        <div class="font-medium">You need at least two locations to transfer stock.</div>
        <div class="text-sm mt-1">Create locations in the database (e.g., 'Main' and 'Outlet'). If you need, I can add a simple Locations admin later.</div>
      </div>
    @endif
    @if (isset($errors) && $errors->any())
      <div class="mb-4 rounded border border-red-200 bg-red-50 text-red-800 px-4 py-2">
        <div class="font-medium">Please fix the errors below</div>
        <ul class="list-disc ms-5 mt-1">
          @foreach ($errors->all() as $error)
            <li>{{ $error }}</li>
          @endforeach
        </ul>
      </div>
    @endif
    @if(session('status'))
      <div class="mb-4 rounded border border-emerald-200 bg-emerald-50 text-emerald-800 px-4 py-2">{{ session('status') }}</div>
    @endif

    <div class="bg-white/80 dark:bg-slate-800/80 rounded-lg border border-white/30 dark:border-slate-700/50 p-6">
      <form method="POST" action="{{ route('admin.inventory.transfer.store') }}" class="grid gap-4">
        @csrf
        <div>
          <label class="block text-sm font-medium mb-1">Dish</label>
          <select name="dish_id" class="w-full border rounded px-3 py-2 dark:bg-slate-900 dark:border-slate-700" required>
            <option value="">Select dish...</option>
            @foreach($dishes as $d)
              <option value="{{ $d->id }}" @selected(old('dish_id')==$d->id)>{{ $d->name }} (Stock: {{ $d->stock }})</option>
            @endforeach
          </select>
        </div>
        <div class="grid sm:grid-cols-2 gap-4">
          <div>
            <label class="block text-sm font-medium mb-1">From Location</label>
            <select name="from_location_id" class="w-full border rounded px-3 py-2 dark:bg-slate-900 dark:border-slate-700" required>
              <option value="">Select location...</option>
              @foreach($locations as $loc)
                <option value="{{ $loc->id }}" @selected(old('from_location_id')==$loc->id)>{{ $loc->name }} ({{ $loc->code }})</option>
              @endforeach
            </select>
          </div>
          <div>
            <label class="block text-sm font-medium mb-1">To Location</label>
            <select name="to_location_id" class="w-full border rounded px-3 py-2 dark:bg-slate-900 dark:border-slate-700" required>
              <option value="">Select location...</option>
              @foreach($locations as $loc)
                <option value="{{ $loc->id }}" @selected(old('to_location_id')==$loc->id)>{{ $loc->name }} ({{ $loc->code }})</option>
              @endforeach
            </select>
          </div>
        </div>
        <div>
          <label class="block text-sm font-medium mb-1">Quantity</label>
          <input type="number" name="quantity" min="1" step="1" value="{{ old('quantity', 1) }}" class="w-full border rounded px-3 py-2 dark:bg-slate-900 dark:border-slate-700" required />
        </div>
        <div>
          <label class="block text-sm font-medium mb-1">Note (optional)</label>
          <input type="text" name="note" value="{{ old('note') }}" class="w-full border rounded px-3 py-2 dark:bg-slate-900 dark:border-slate-700" />
        </div>
        <div class="flex items-center gap-3 pt-2">
          <button class="inline-flex items-center gap-2 px-4 py-2 bg-indigo-600 text-white rounded hover:bg-indigo-700">
            <i data-lucide="swap-horizontal" class="w-4 h-4"></i>
            Transfer
          </button>
          <a href="{{ route('admin.inventory.movements') }}" class="px-4 py-2 border rounded dark:border-slate-600">Cancel</a>
        </div>
      </form>
    </div>
  </div>
</x-admin-layout>
