<x-admin-layout>
  <x-slot name="header">
    <div>
      <h2 class="font-semibold text-xl">Edit Location</h2>
      <x-admin.breadcrumbs :items="[['label' => 'Inventory', 'url' => route('admin.inventory.index')], ['label' => 'Locations', 'url' => route('admin.locations.index')], ['label' => 'Edit']]" />
    </div>
  </x-slot>

  <div class="max-w-3xl mx-auto p-4">
    @if ($errors->any())
      <div class="mb-4 rounded border border-red-200 bg-red-50 text-red-800 px-4 py-2">
        <div class="font-medium">Please fix the errors below</div>
        <ul class="list-disc ms-5 mt-1">
          @foreach ($errors->all() as $error)
            <li>{{ $error }}</li>
          @endforeach
        </ul>
      </div>
    @endif

    <div class="bg-white/80 dark:bg-slate-800/80 rounded-lg border border-white/30 dark:border-slate-700/50 p-6">
      <form method="POST" action="{{ route('admin.locations.update', $location) }}" class="grid gap-4">
        @csrf
        @method('PUT')
        <div>
          <label class="block text-sm font-medium mb-1">Name</label>
          <input type="text" name="name" value="{{ old('name', $location->name) }}" class="w-full border rounded px-3 py-2 dark:bg-slate-900 dark:border-slate-700" required />
        </div>
        <div>
          <label class="block text-sm font-medium mb-1">Code</label>
          <input type="text" name="code" value="{{ old('code', $location->code) }}" class="w-full border rounded px-3 py-2 dark:bg-slate-900 dark:border-slate-700" required />
        </div>
        <div>
          <label class="block text-sm font-medium mb-1">Type</label>
          <input type="text" name="type" value="{{ old('type', $location->type) }}" class="w-full border rounded px-3 py-2 dark:bg-slate-900 dark:border-slate-700" />
        </div>
        <div>
          <label class="block text-sm font-medium mb-1">Address</label>
          <input type="text" name="address" value="{{ old('address', $location->address) }}" class="w-full border rounded px-3 py-2 dark:bg-slate-900 dark:border-slate-700" />
        </div>
        <div class="flex items-center gap-2">
          <input id="is_active" type="checkbox" name="is_active" value="1" @checked(old('is_active', $location->is_active)) />
          <label for="is_active">Active</label>
        </div>
        <div class="flex items-center gap-3 pt-2">
          <button class="inline-flex items-center gap-2 px-4 py-2 bg-indigo-600 text-white rounded hover:bg-indigo-700">
            <i data-lucide="save" class="w-4 h-4"></i>
            Update
          </button>
          <a href="{{ route('admin.locations.index') }}" class="px-4 py-2 border rounded dark:border-slate-600">Cancel</a>
        </div>
      </form>
    </div>
  </div>
</x-admin-layout>
