<x-admin-layout>
  <x-slot name="header">
    <div>
      <h2 class="font-semibold text-xl">Locations</h2>
      <x-admin.breadcrumbs :items="[['label' => 'Inventory', 'url' => route('admin.inventory.index')], ['label' => 'Locations']]" />
    </div>
  </x-slot>

  <div class="max-w-5xl mx-auto p-4">
    @if(session('status'))
      <div class="mb-4 rounded border border-emerald-200 bg-emerald-50 text-emerald-800 px-4 py-2">{{ session('status') }}</div>
    @endif

    <div class="flex justify-between items-center mb-4">
      <h3 class="text-lg font-semibold">All Locations</h3>
      <a href="{{ route('admin.locations.create') }}" class="inline-flex items-center gap-2 px-3 py-2 bg-indigo-600 text-white rounded hover:bg-indigo-700">
        <i data-lucide="plus" class="w-4 h-4"></i> New Location
      </a>
    </div>

    <div class="overflow-hidden rounded-lg border border-white/30 dark:border-slate-700/50 bg-white/80 dark:bg-slate-800/80">
      <div class="overflow-x-auto">
        <table class="min-w-full text-sm">
          <thead class="bg-gray-50/90 dark:bg-slate-900/70 backdrop-blur text-left text-gray-700 dark:text-slate-300">
            <tr>
              <th class="px-4 py-3">Name</th>
              <th class="px-4 py-3">Code</th>
              <th class="px-4 py-3">Type</th>
              <th class="px-4 py-3">Active</th>
              <th class="px-4 py-3">Address</th>
              <th class="px-4 py-3 text-right">Actions</th>
            </tr>
          </thead>
          <tbody class="divide-y divide-gray-100/60 dark:divide-slate-700/50">
            @forelse($locations as $loc)
            <tr>
              <td class="px-4 py-3">{{ $loc->name }}</td>
              <td class="px-4 py-3">{{ $loc->code }}</td>
              <td class="px-4 py-3">{{ $loc->type ?? '—' }}</td>
              <td class="px-4 py-3">{!! $loc->is_active ? '<span class="text-emerald-600">Yes</span>' : '<span class="text-gray-500">No</span>' !!}</td>
              <td class="px-4 py-3">{{ $loc->address ?? '—' }}</td>
              <td class="px-4 py-3 text-right">
                <a href="{{ route('admin.locations.edit', $loc) }}" class="inline-flex items-center gap-1 px-3 py-1.5 border rounded hover:bg-gray-50 dark:hover:bg-slate-700">Edit</a>
                <form action="{{ route('admin.locations.destroy', $loc) }}" method="POST" class="inline" onsubmit="return confirm('Delete this location?')">
                  @csrf
                  @method('DELETE')
                  <button class="inline-flex items-center gap-1 px-3 py-1.5 border border-red-300 text-red-700 rounded hover:bg-red-50">Delete</button>
                </form>
              </td>
            </tr>
            @empty
            <tr>
              <td colspan="6" class="px-4 py-6 text-center text-gray-500">No locations yet.</td>
            </tr>
            @endforelse
          </tbody>
        </table>
      </div>
      <div class="p-3">{{ $locations->links() }}</div>
    </div>
  </div>
</x-admin-layout>
