<x-admin-layout>
  <x-slot name="header">
    <div>
      <h2 class="font-semibold text-xl">Orders</h2>
      <x-admin.breadcrumbs :items="[[ 'label' => 'Orders' ]]" />
    </div>
  </x-slot>

  <div class="py-6">
    <div class="container-px" data-aos="fade-up">
      @if(session('status'))
        <div class="mb-4 badge badge-accent text-sm">{{ session('status') }}</div>
      @endif
      <div class="mb-4 flex flex-wrap gap-2 text-sm">
        @php($cur = request('status'))
        <a href="{{ route('admin.orders.index') }}" class="badge {{ $cur ? '' : 'badge-accent' }}">All</a>
        @foreach(\App\Models\Order::STATUSES as $s)
          <a href="{{ route('admin.orders.index', array_merge(request()->except('page'), ['status'=>$s])) }}" class="badge {{ $cur===$s ? 'badge-accent' : '' }}">{{ $s }}</a>
        @endforeach
      </div>

  <form method="GET" class="mb-4 grid md:grid-cols-7 gap-2 text-sm" id="filters-form" role="search">
        <div class="relative md:col-span-2">
          <input type="text" name="q" id="filter-q" value="{{ $q ?? request('q') }}" placeholder="Search #, customer, payment" class="input pr-8" />
          <button type="button" id="clear-q" aria-label="Clear search" class="absolute right-2 top-1/2 -translate-y-1/2 text-gray-400 hover:text-gray-700 dark:hover:text-gray-200 {{ ($q ?? request('q')) ? '' : 'hidden' }}">&times;</button>
        </div>
        <select name="status" class="select">
          <option value="">All Statuses</option>
          @foreach(\App\Models\Order::STATUSES as $s)
            <option value="{{ $s }}" @selected(request('status')===$s)>{{ $s }}</option>
          @endforeach
        </select>
        <select name="payment_method" class="select">
          <option value="">All Payments</option>
          @foreach(['Cash on Delivery','Paystack','Charge to Room'] as $pm)
            <option value="{{ $pm }}" @selected(request('payment_method')===$pm)>{{ $pm }}</option>
          @endforeach
        </select>
        <input type="date" name="from" value="{{ request('from') }}" class="input" />
        <input type="date" name="to" value="{{ request('to') }}" class="input" />
        <select name="perPage" class="select">
          @foreach([10,20,25,50,100] as $n)
            <option value="{{ $n }}" @selected(($perPage ?? request('perPage',20))==$n)>{{ $n }}/page</option>
          @endforeach
        </select>
        <div class="flex gap-2">
          <button class="btn btn-primary">Filter</button>
          <a href="{{ route('admin.orders.index') }}" class="btn btn-outline">Reset</a>
          <a href="{{ route('admin.orders.export', request()->all()) }}" class="btn btn-outline" title="Export CSV">Export</a>
        </div>
      </form>


      @isset($counts)
      <div class="mb-3 flex flex-wrap gap-2 text-xs">
        @foreach($counts as $label => $num)
          <button type="button" data-filter-status="{{ $label }}" class="badge">
            {{ $label }}: <b>{{ $num }}</b>
          </button>
        @endforeach
      </div>
      @endisset

      <div class="overflow-hidden rounded-xl surface-glass">
        <form method="POST" action="{{ route('admin.orders.bulk-update') }}" id="bulk-form">
          @csrf
          <div class="flex items-center justify-between px-4 py-3 border-b border-subtle bg-white/40 dark:bg-white/5">
            <div class="flex items-center gap-2 text-sm">
              <select name="status" class="input h-9 py-1 px-2 w-auto">
                <option value="">Bulk: Set status…</option>
                @foreach(\App\Models\Order::STATUSES as $s)
                  <option value="{{ $s }}">{{ $s }}</option>
                @endforeach
              </select>
              <input type="text" name="note" placeholder="Optional note" class="input h-9 py-1 px-2 w-56" />
              <input type="hidden" name="select_mode" value="page" id="select-mode" />
              <button class="btn btn-secondary text-xs h-9 py-1.5" id="bulk-apply" disabled>Apply</button>
            </div>
            <div class="text-xs text-gray-600 dark:text-slate-300 flex items-center gap-2">
              <span><span id="selected-count">0</span> selected</span>
              @isset($totalMatching)
                <button type="button" id="select-all-matching" class="underline">Select all {{ $totalMatching }} matching</button>
                <button type="button" id="clear-selection" class="underline hidden">Clear selection</button>
              @endisset
            </div>
          </div>

    <table class="min-w-full text-sm" id="orders-table">
            <thead class="sticky top-0 z-10 backdrop-blur bg-white/70 dark:bg-slate-900/60 text-left">
              <tr>
                <th class="px-4 py-3"><input type="checkbox" id="select-all"></th>
                <th class="px-4 py-3">
      <a href="{{ request()->url() . '?' . http_build_query(array_merge(request()->except(['page','sort','dir']), ['sort'=>'id','dir'=>(request('sort')==='id' && request('dir','desc')==='asc') ? 'desc' : 'asc'])) }}" class="inline-flex items-center gap-1"># <span class="opacity-60">@if(request('sort','created')==='id') {{ request('dir','desc')==='asc'?'▲':'▼' }} @endif</span></a>
                </th>
                <th class="px-4 py-3">
      <a href="{{ request()->url() . '?' . http_build_query(array_merge(request()->except(['page','sort','dir']), ['sort'=>'customer','dir'=>(request('sort')==='customer' && request('dir','desc')==='asc') ? 'desc' : 'asc'])) }}" class="inline-flex items-center gap-1">Customer <span class="opacity-60">@if(request('sort','created')==='customer') {{ request('dir','desc')==='asc'?'▲':'▼' }} @endif</span></a>
                </th>
                <th class="px-4 py-3">
      <a href="{{ request()->url() . '?' . http_build_query(array_merge(request()->except(['page','sort','dir']), ['sort'=>'payment','dir'=>(request('sort')==='payment' && request('dir','desc')==='asc') ? 'desc' : 'asc'])) }}" class="inline-flex items-center gap-1">Payment <span class="opacity-60">@if(request('sort','created')==='payment') {{ request('dir','desc')==='asc'?'▲':'▼' }} @endif</span></a>
                </th>
                <th class="px-4 py-3">
      <a href="{{ request()->url() . '?' . http_build_query(array_merge(request()->except(['page','sort','dir']), ['sort'=>'total','dir'=>(request('sort')==='total' && request('dir','desc')==='asc') ? 'desc' : 'asc'])) }}" class="inline-flex items-center gap-1">Total <span class="opacity-60">@if(request('sort','created')==='total') {{ request('dir','desc')==='asc'?'▲':'▼' }} @endif</span></a>
                </th>
                <th class="px-4 py-3">
      <a href="{{ request()->url() . '?' . http_build_query(array_merge(request()->except(['page','sort','dir']), ['sort'=>'status','dir'=>(request('sort')==='status' && request('dir','desc')==='asc') ? 'desc' : 'asc'])) }}" class="inline-flex items-center gap-1">Status <span class="opacity-60">@if(request('sort','created')==='status') {{ request('dir','desc')==='asc'?'▲':'▼' }} @endif</span></a>
                </th>
                <th class="px-4 py-3">
      <a href="{{ request()->url() . '?' . http_build_query(array_merge(request()->except(['page','sort','dir']), ['sort'=>'created','dir'=>(request('sort','created')==='created' && request('dir','desc')==='asc') ? 'desc' : 'asc'])) }}" class="inline-flex items-center gap-1">Date <span class="opacity-60">@if(request('sort','created')==='created') {{ request('dir','desc')==='asc'?'▲':'▼' }} @endif</span></a>
                </th>
                <th class="px-4 py-3 text-right">Actions</th>
              </tr>
            <tbody class="divide-y divide-gray-100/60 dark:divide-slate-700/50" id="orders-rows" data-rows-url="{{ route('admin.orders.rows') }}">
              @include('admin.orders.partials.rows', ['orders' => $orders])
            </tbody>
          </table>
        </form>
      </div>
      </div>
      <div class="mt-4">{{ $orders->appends(request()->except('page'))->links() }}</div>
    </div>
  </div>

  <script>
    (function(){
      const rowsEl = document.getElementById('orders-rows');
      const tableEl = document.getElementById('orders-table');
      const bulkForm = document.getElementById('bulk-form');
      const bulkApply = document.getElementById('bulk-apply');
      const selectAll = document.getElementById('select-all');
      const selectedCount = document.getElementById('selected-count');
      const params = new URLSearchParams(window.location.search);
      let hasSelection = false;
  let selectingAllMatching = false;
      // Auto-submit filters
      const filtersForm = document.getElementById('filters-form');
      const qInput = document.getElementById('filter-q');
      const clearQBtn = document.getElementById('clear-q');
      if (filtersForm) {
        // Change on selects and dates
        filtersForm.querySelectorAll('select, input[type="date"]').forEach(el => {
          el.addEventListener('change', () => filtersForm.requestSubmit());
        });
        // Debounce typing in q
        if (qInput) {
          let t;
          qInput.addEventListener('input', () => {
            if (clearQBtn) clearQBtn.classList.toggle('hidden', qInput.value.trim()==='');
            clearTimeout(t); t = setTimeout(() => filtersForm.requestSubmit(), 500);
          });
          qInput.addEventListener('keydown', (e) => {
            if (e.key === 'Escape') { qInput.value=''; if (clearQBtn) clearQBtn.classList.add('hidden'); filtersForm.requestSubmit(); }
          });
        }
        // Clear button
        clearQBtn?.addEventListener('click', () => { if (qInput) { qInput.value=''; clearQBtn.classList.add('hidden'); filtersForm.requestSubmit(); } });
      }
      const refresh = async () => {
        try {
          const base = rowsEl.getAttribute('data-rows-url');
          const url = new URL(base, window.location.origin);
          params.forEach((v,k)=>url.searchParams.set(k,v));
          const res = await fetch(url, { headers: { 'X-Requested-With':'XMLHttpRequest' }});
          if (!res.ok) return;
          if (hasSelection && !selectingAllMatching) return; // don't clobber selected checkboxes while user is working
          rowsEl.innerHTML = await res.text();
          if (window.lucide) window.lucide.createIcons();
          bindRowCheckboxes();
        } catch (e) { /* swallow */ }
      };
      // Auto-refresh every 20s
      setInterval(refresh, 20000);
      // Clickable chips for counts
      document.querySelectorAll('[data-filter-status]').forEach(chip => {
        chip.addEventListener('click', () => {
          params.set('status', chip.getAttribute('data-filter-status'));
          window.location.search = params.toString();
        });
      });

      function bindRowCheckboxes(){
        const boxes = rowsEl.querySelectorAll('input[name="order_ids[]"]');
        function updateState(){
          const checked = rowsEl.querySelectorAll('input[name="order_ids[]"]:checked');
          hasSelection = checked.length > 0 || selectingAllMatching;
          const statusSelect = bulkForm?.querySelector('select[name="status"]');
          const statusChosen = statusSelect && statusSelect.value !== '';
          bulkApply.disabled = !(hasSelection && statusChosen);
          selectedCount.textContent = selectingAllMatching ? '{{ $totalMatching ?? 0 }}' : checked.length.toString();
        }
        boxes.forEach(b => b.addEventListener('change', updateState));
        if (selectAll) {
          selectAll.addEventListener('change', () => {
            boxes.forEach(b => b.checked = selectAll.checked);
            updateState();
          });
        }
        const statusSelect = bulkForm?.querySelector('select[name="status"]');
        statusSelect?.addEventListener('change', updateState);
        updateState();
      }
      bindRowCheckboxes();

      const selectAllMatchingBtn = document.getElementById('select-all-matching');
      const clearSelectionBtn = document.getElementById('clear-selection');
      const selectMode = document.getElementById('select-mode');
      selectAllMatchingBtn?.addEventListener('click', () => {
        selectingAllMatching = true;
        selectMode.value = 'all';
        clearSelectionBtn?.classList.remove('hidden');
        hasSelection = true;
        const statusSelect = bulkForm?.querySelector('select[name="status"]');
        bulkApply.disabled = !(hasSelection && statusSelect && statusSelect.value !== '');
        selectedCount.textContent = '{{ $totalMatching ?? 0 }}';
      });
      clearSelectionBtn?.addEventListener('click', () => {
        selectingAllMatching = false;
        selectMode.value = 'page';
        clearSelectionBtn?.classList.add('hidden');
        rowsEl.querySelectorAll('input[name="order_ids[]"]').forEach(b=>b.checked=false);
        hasSelection = false;
        bulkApply.disabled = true;
        selectedCount.textContent = '0';
      });

      bulkForm?.addEventListener('submit', (e) => {
        if (!confirm('Apply this update?')) { e.preventDefault(); return; }
        if (selectingAllMatching) {
          // Convert to a special bulk-all request by sending current filters
          const hidden = document.createElement('input');
          hidden.type = 'hidden'; hidden.name = 'filters'; hidden.value = window.location.search.substring(1);
          bulkForm.appendChild(hidden);
        }
      });
    })();
  </script>
</x-admin-layout>
