@forelse($orders as $order)
<tr>
  <td class="px-4 py-3"><input type="checkbox" name="order_ids[]" value="{{ $order->id }}" class="row-select"></td>
  <td class="px-4 py-3">{{ $order->id }}</td>
  <td class="px-4 py-3">{{ $order->user?->name ?? 'Guest' }}</td>
  <td class="px-4 py-3">{{ $order->payment_method }}</td>
  <td class="px-4 py-3">₦{{ number_format($order->total, 2) }}</td>
  <td class="px-4 py-3"><x-status-badge :status="$order->status" /></td>
  <td class="px-4 py-3">{{ $order->created_at->format('Y-m-d H:i') }}</td>
  <td class="px-4 py-3 text-right">
    <div class="flex gap-2 justify-end">
      <a class="btn btn-outline text-xs" href="{{ route('admin.orders.show', $order) }}"><i data-lucide="eye" class="w-4 h-4"></i> View</a>
      @php($next = match($order->status){
        'Received' => 'In Kitchen',
        'In Kitchen' => 'Ready',
        'Ready' => 'Out for Delivery',
        'Out for Delivery' => 'Delivered',
        default => null,
      })
      @if($next)
        <form method="POST" action="{{ route('admin.orders.update', $order) }}">
          @csrf
          @method('PATCH')
          <input type="hidden" name="status" value="{{ $next }}" />
          <button class="btn btn-primary text-xs" title="Mark as {{ $next }}"><i data-lucide="chevron-right" class="w-4 h-4"></i> {{ $next }}</button>
        </form>
      @endif
    </div>
  </td>
</tr>
@empty
<tr><td colspan="8" class="px-4 py-8 text-center text-gray-500">No orders yet.</td></tr>
@endforelse
