<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Order #{{ $order->id }} Ticket</title>
  <style>
    body { font-family: ui-sans-serif, system-ui, -apple-system, Segoe UI, Roboto, Helvetica, Arial, "Apple Color Emoji", "Segoe UI Emoji"; }
    .ticket { width: 320px; margin: 0 auto; }
    h1 { font-size: 16px; margin: 0 0 8px; }
    table { width: 100%; border-collapse: collapse; font-size: 12px; }
    th, td { text-align: left; padding: 4px 0; }
    tfoot td { border-top: 1px solid #000; font-weight: 600; }
    .muted { color: #555; font-size: 11px; }
    @media print { .no-print { display:none } body { margin:0 } }
  </style>
</head>
<body>
  <div class="ticket">
    <h1>Bonny Delight — Order #{{ $order->id }}</h1>
    <div class="muted">{{ $order->created_at->format('Y-m-d H:i') }} | {{ $order->user?->name ?? 'Guest' }}</div>
    <hr>
    <table>
      <thead>
        <tr><th>Item</th><th style="text-align:right;">Qty</th><th style="text-align:right;">Total</th></tr>
      </thead>
      <tbody>
        @foreach($order->items as $item)
          <tr>
            <td>{{ $item->dish?->name ?? '—' }}</td>
            <td style="text-align:right;">{{ $item->quantity }}</td>
            <td style="text-align:right;">₦{{ number_format($item->price * $item->quantity, 2) }}</td>
          </tr>
        @endforeach
      </tbody>
      <tfoot>
        <tr><td>Subtotal</td><td></td><td style="text-align:right;">₦{{ number_format($order->subtotal, 2) }}</td></tr>
        <tr><td>Delivery</td><td></td><td style="text-align:right;">₦{{ number_format($order->delivery_fee, 2) }}</td></tr>
        @if($order->discount > 0)
        <tr><td>Discount</td><td></td><td style="text-align:right;">-₦{{ number_format($order->discount, 2) }}</td></tr>
        @endif
        @if(($order->tip ?? 0) > 0)
        <tr><td>Tip</td><td></td><td style="text-align:right;">₦{{ number_format($order->tip, 2) }}</td></tr>
        @endif
        <tr><td>Total</td><td></td><td style="text-align:right;">₦{{ number_format($order->total, 2) }}</td></tr>
      </tfoot>
    </table>
    @if($order->delivery_address)
    <p class="muted">Deliver to: {{ $order->delivery_address }}</p>
    @endif
    <div class="no-print" style="margin-top:12px;">
      <button onclick="window.print()">Print</button>
    </div>
  </div>
</body>
</html>
