<x-admin-layout>
  <x-slot name="header">
    <div>
      <h2 class="font-semibold text-xl flex items-center gap-3">Order #{{ $order->id }} <x-status-badge :status="$order->status" /></h2>
      <x-admin.breadcrumbs :items="[[ 'label' => 'Orders', 'url' => route('admin.orders.index') ], [ 'label' => '#'.$order->id ]]" />
    </div>
    <div class="ml-auto">
  <a href="{{ route('admin.orders.print', $order) }}" target="_blank" class="btn btn-outline text-sm"><i data-lucide="printer" class="w-4 h-4"></i>Print</a>
    </div>
  </x-slot>

  <div class="py-6">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8" data-aos="fade-up">
      @if(session('status'))
        <div class="mb-4 badge badge-accent text-sm">{{ session('status') }}</div>
      @endif

      <div class="grid md:grid-cols-3 gap-4">
        <div class="md:col-span-2 space-y-4">
          <div class="surface rounded-xl p-4">
            <div class="flex items-center gap-2 mb-2"><i data-lucide="list-ordered" class="w-5 h-5 text-indigo-600"></i><h2 class="font-semibold">Items</h2></div>
            <table class="w-full text-sm">
              <thead class="text-left text-gray-600 dark:text-slate-300">
                <tr>
                  <th class="py-2">Dish</th>
                  <th class="py-2">Qty</th>
                  <th class="py-2">Price</th>
                  <th class="py-2">Total</th>
                </tr>
              </thead>
              <tbody class="divide-y divide-gray-100/60 dark:divide-slate-700/50">
              @foreach($order->items as $item)
                <tr>
                  <td class="py-2">{{ $item->dish?->name ?? '—' }}</td>
                  <td class="py-2">{{ $item->quantity }}</td>
                  <td class="py-2">₦{{ number_format($item->price, 2) }}</td>
                  <td class="py-2">₦{{ number_format($item->price * $item->quantity, 2) }}</td>
                </tr>
              @endforeach
              </tbody>
            </table>
          </div>

          <div class="surface rounded-xl p-4">
            <div class="flex items-center gap-2 mb-2"><i data-lucide="calculator" class="w-5 h-5 text-emerald-600"></i><h2 class="font-semibold">Totals</h2></div>
            <dl class="text-sm space-y-1">
              <div class="flex justify-between"><dt>Subtotal</dt><dd>₦{{ number_format($order->subtotal, 2) }}</dd></div>
              <div class="flex justify-between"><dt>Delivery</dt><dd>₦{{ number_format($order->delivery_fee, 2) }}</dd></div>
              <div class="flex justify-between"><dt>Discount</dt><dd>-₦{{ number_format($order->discount, 2) }}</dd></div>
              <div class="flex justify-between"><dt>Tip</dt><dd>₦{{ number_format($order->tip ?? 0, 2) }}</dd></div>
              <div class="flex justify-between font-semibold"><dt>Total</dt><dd>₦{{ number_format($order->total, 2) }}</dd></div>
            </dl>
          </div>
          <div class="surface rounded-xl p-4">
            <div class="flex items-center gap-2 mb-2"><i data-lucide="timeline" class="w-5 h-5 text-purple-600"></i><h2 class="font-semibold">Timeline</h2></div>
            <ol class="relative border-s border-gray-200 dark:border-slate-700 pl-4 text-sm">
              @foreach($order->statusEvents as $ev)
                <li class="mb-3">
                  <div class="absolute -left-1.5 w-3 h-3 rounded-full bg-purple-500"></div>
                  <div class="flex items-center gap-2">
                    <span class="font-medium">{{ $ev->status }}</span>
                    <span class="text-gray-500">— {{ $ev->created_at->format('Y-m-d H:i') }}</span>
                  </div>
                  <div class="text-gray-600 dark:text-slate-300">{{ $ev->user?->name ?? 'System' }}</div>
                  @if($ev->note)
                    <div class="text-gray-500">{{ $ev->note }}</div>
                  @endif
                </li>
              @endforeach
            </ol>
          </div>
        </div>

        <div class="space-y-4">
          <div class="surface rounded-xl p-4">
            <div class="flex items-center gap-2 mb-2"><i data-lucide="user" class="w-5 h-5 text-slate-600"></i><h2 class="font-semibold">Customer</h2></div>
            <p class="text-sm">{{ $order->user?->name ?? 'Guest' }}<br>{{ $order->user?->email ?? '' }}</p>
          </div>
          <div class="surface rounded-xl p-4">
            <div class="flex items-center gap-2 mb-2"><i data-lucide="truck" class="w-5 h-5 text-slate-600"></i><h2 class="font-semibold">Delivery</h2></div>
            <dl class="text-sm space-y-1">
              <div class="flex justify-between"><dt>Mode</dt><dd>
                @if($order->delivery_mode === 'room')
                  <span class="inline-flex items-center gap-1 px-2 py-0.5 text-xs rounded bg-indigo-100 text-indigo-700 dark:bg-indigo-500/20 dark:text-indigo-300">Room</span>
                @else
                  <span class="inline-flex items-center gap-1 px-2 py-0.5 text-xs rounded bg-emerald-100 text-emerald-700 dark:bg-emerald-500/20 dark:text-emerald-300">External</span>
                @endif
              </dd></div>
              <div class="flex justify-between"><dt>Address</dt>
                <dd class="max-w-[220px] truncate flex items-center gap-2" title="{{ $order->display_delivery_address }}">
                  @if($order->delivery_mode === 'room' || (isset($order->display_delivery_address) && preg_match('/^room\s*[-#]?[a-z0-9]+$/i', $order->display_delivery_address ?? '')))
                    <span class="inline-flex items-center gap-1 px-2 py-0.5 text-xs rounded bg-indigo-100 text-indigo-700 dark:bg-indigo-500/20 dark:text-indigo-300">Hotel Guest</span>
                  @else
                    <span class="inline-flex items-center gap-1 px-2 py-0.5 text-xs rounded bg-emerald-100 text-emerald-700 dark:bg-emerald-500/20 dark:text-emerald-300">External</span>
                  @endif
                  <span>{{ $order->display_delivery_address ?? '—' }}</span>
                </dd>
              </div>
              <div class="flex justify-between"><dt>Verified</dt><dd>
                @if($order->delivery_address_verified)
                  <span class="text-emerald-600 dark:text-emerald-400">Yes</span>
                @else
                  <span class="text-amber-600 dark:text-amber-400">No</span>
                @endif
              </dd></div>
              <div class="flex justify-between"><dt>Distance</dt><dd>{{ $order->delivery_distance_km !== null ? $order->delivery_distance_km.' km' : '—' }}</dd></div>
              <div class="flex justify-between"><dt>Lat/Lng</dt><dd>{{ $order->delivery_latitude ? ($order->delivery_latitude.', '.$order->delivery_longitude) : '—' }}</dd></div>
            </dl>
            @if($order->verification_log)
              <details class="mt-2 text-xs">
                <summary class="cursor-pointer text-indigo-600">Verification Log</summary>
                <pre class="mt-1 p-2 bg-slate-900 text-slate-200 rounded overflow-x-auto">{{ json_encode(json_decode($order->verification_log, true), JSON_PRETTY_PRINT|JSON_UNESCAPED_SLASHES) }}</pre>
              </details>
            @endif
          </div>
          <div class="bg-white/80 dark:bg-slate-800/80 rounded-lg border border-white/30 dark:border-slate-700/50 p-4">
            <div class="flex items-center gap-2 mb-2"><i data-lucide="activity" class="w-5 h-5 text-indigo-600"></i><h2 class="font-semibold">Status</h2></div>
            <form method="POST" action="{{ route('admin.orders.update', $order) }}" class="space-y-2">
              @csrf
              @method('PATCH')
              <select name="status" class="input">
                @foreach(\App\Models\Order::STATUSES as $status)
                  <option value="{{ $status }}" @selected($order->status === $status)>{{ $status }}</option>
                @endforeach
              </select>
              <input type="text" name="note" placeholder="Optional note" class="input" />
              <button class="btn btn-primary w-full justify-center"><i data-lucide="save" class="w-4 h-4"></i>Update</button>
            </form>
            @php($next = match($order->status){
              'Received' => 'In Kitchen',
              'In Kitchen' => 'Ready',
              'Ready' => 'Out for Delivery',
              'Out for Delivery' => 'Delivered',
              default => null,
            })
            @if($next)
              <form method="POST" action="{{ route('admin.orders.update', $order) }}" class="mt-2">
                @csrf
                @method('PATCH')
                <input type="hidden" name="status" value="{{ $next }}" />
                <button class="btn btn-secondary w-full justify-center" title="Mark as {{ $next }}"><i data-lucide="check-circle" class="w-4 h-4"></i>Mark {{ $next }}</button>
              </form>
            @endif
          </div>
        </div>
      </div>
    </div>
  </div>
</x-admin-layout>
