<x-admin-layout>
  <x-slot name="header">
    <div>
      <h2 class="font-semibold text-xl">Settings</h2>
      <x-admin.breadcrumbs :items="[[ 'label' => 'Settings' ]]" />
    </div>
  </x-slot>

  <div class="py-6">
    <div class="max-w-4xl mx-auto px-4 sm:px-6 lg:px-8" data-aos="fade-up">
      @if(session('status'))
        <div class="mb-4 rounded border border-emerald-200 bg-emerald-50 text-emerald-800 px-4 py-2">{{ session('status') }}</div>
      @endif

      <form method="POST" action="{{ route('admin.settings.update') }}" class="space-y-6">
        @csrf
        @method('PUT')

        <div class="bg-white/80 dark:bg-slate-800/80 rounded-lg border border-white/30 dark:border-slate-700/50 p-4">
          <div class="flex items-center gap-2 mb-3"><i data-lucide="building-2" class="w-5 h-5 text-indigo-600"></i><h3 class="font-semibold">Business</h3></div>
          <div class="grid sm:grid-cols-2 gap-4">
            <div>
              <label class="block text-sm mb-1">Name</label>
              <input type="text" name="settings[business.name]" value="{{ old('settings.business.name', \App\Models\Setting::get('business.name','')) }}" class="w-full border rounded px-3 py-2 dark:bg-slate-900 dark:border-slate-700">
            </div>
            <div>
              <label class="block text-sm mb-1">PWA Enabled</label>
              <label class="inline-flex items-center gap-2 text-sm"><input type="checkbox" name="settings[pwa.enabled]" value="1" @checked(\App\Models\Setting::get('pwa.enabled', true))> Enable</label>
            </div>
          </div>
        </div>

        <div class="bg-white/80 dark:bg-slate-800/80 rounded-lg border border-white/30 dark:border-slate-700/50 p-4">
          <div class="flex items-center gap-2 mb-3"><i data-lucide="shopping-basket" class="w-5 h-5 text-amber-600"></i><h3 class="font-semibold">Orders</h3></div>
          <div class="grid sm:grid-cols-3 gap-4">
            <div>
              <label class="block text-sm mb-1">Min Subtotal (₦)</label>
              <input type="number" step="0.01" name="settings[order.min_subtotal]" value="{{ old('settings.order.min_subtotal', \App\Models\Setting::get('order.min_subtotal', 0)) }}" class="w-full border rounded px-3 py-2 dark:bg-slate-900 dark:border-slate-700">
            </div>
            <div>
              <label class="block text-sm mb-1">Service Charge %</label>
              <input type="number" step="0.01" name="settings[order.service_charge_percent]" value="{{ old('settings.order.service_charge_percent', \App\Models\Setting::get('order.service_charge_percent', 0)) }}" class="w-full border rounded px-3 py-2 dark:bg-slate-900 dark:border-slate-700">
            </div>
            <div>
              <label class="block text-sm mb-1">Max Open Orders</label>
              <input type="number" step="1" name="settings[capacity.max_open_orders]" value="{{ old('settings.capacity.max_open_orders', \App\Models\Setting::get('capacity.max_open_orders', 50)) }}" class="w-full border rounded px-3 py-2 dark:bg-slate-900 dark:border-slate-700">
            </div>
          </div>
        </div>

        <div class="bg-white/80 dark:bg-slate-800/80 rounded-lg border border-white/30 dark:border-slate-700/50 p-4">
          <div class="flex items-center gap-2 mb-3"><i data-lucide="truck" class="w-5 h-5 text-emerald-600"></i><h3 class="font-semibold">Delivery</h3></div>
          <div class="grid sm:grid-cols-2 gap-4">
            <div>
              <label class="block text-sm mb-1">Base Fee (₦)</label>
              <input type="number" step="0.01" name="settings[delivery.fee_base]" value="{{ old('settings.delivery.fee_base', \App\Models\Setting::get('delivery.fee_base', 1000)) }}" class="w-full border rounded px-3 py-2 dark:bg-slate-900 dark:border-slate-700">
            </div>
            <div>
              <label class="block text-sm mb-1">Free Delivery Threshold (₦)</label>
              <input type="number" step="0.01" name="settings[delivery.free_threshold]" value="{{ old('settings.delivery.free_threshold', \App\Models\Setting::get('delivery.free_threshold', 20000)) }}" class="w-full border rounded px-3 py-2 dark:bg-slate-900 dark:border-slate-700">
            </div>
          </div>
        </div>

        <div class="bg-white/80 dark:bg-slate-800/80 rounded-lg border border-white/30 dark:border-slate-700/50 p-4">
          <div class="flex items-center gap-2 mb-3"><i data-lucide="bed" class="w-5 h-5 text-purple-600"></i><h3 class="font-semibold">Room Service</h3></div>
          <div class="grid sm:grid-cols-3 gap-4">
            <div>
              <label class="block text-sm mb-1">Enabled</label>
              <label class="inline-flex items-center gap-2 text-sm"><input type="checkbox" name="settings[room_service.enabled]" value="1" @checked(\App\Models\Setting::get('room_service.enabled', true))> Enable</label>
            </div>
            <div>
              <label class="block text-sm mb-1">Min Order (₦)</label>
              <input type="number" step="0.01" name="settings[room_service.min_order]" value="{{ old('settings.room_service.min_order', \App\Models\Setting::get('room_service.min_order', 0)) }}" class="w-full border rounded px-3 py-2 dark:bg-slate-900 dark:border-slate-700">
            </div>
            <div>
              <label class="block text-sm mb-1">Verification Mode</label>
              @php($mode = \App\Models\Setting::get('room_service.verification_mode','phone'))
              <select name="settings[room_service.verification_mode]" class="w-full border rounded px-3 py-2 dark:bg-slate-900 dark:border-slate-700">
                <option value="phone" @selected($mode==='phone')>Phone</option>
                <option value="pin" @selected($mode==='pin')>PIN</option>
                <option value="none" @selected($mode==='none')>None</option>
              </select>
            </div>
          </div>
        </div>

        <div class="flex gap-2">
          <a href="{{ route('admin.dashboard') }}" class="px-4 py-2 border rounded">Cancel</a>
          <button class="inline-flex items-center gap-2 px-4 py-2 bg-indigo-600 text-white rounded"><i data-lucide="save" class="w-4 h-4"></i>Save</button>
        </div>
      </form>
    </div>
  </div>
</x-admin-layout>
