<x-guest-layout>
    <div class="space-y-6">
        <div class="text-center">
            <h1 class="text-3xl font-extrabold tracking-tight">{{ __('Reset Password') }}</h1>
            <p class="mt-2 text-sm text-muted">{{ __('Enter your email and we will send you a reset link.') }}</p>
        </div>
        <x-auth-session-status class="mb-2" :status="session('status')" />
        @if($errors->has('email'))
            <div class="rounded-md border border-amber-300/60 bg-amber-50 text-amber-900 dark:bg-amber-950/40 dark:text-amber-200 p-3 text-sm mb-2">
                {{ $errors->first('email') }}
            </div>
        @endif
        <form method="POST" action="{{ route('password.email') }}" class="form-stack">
            @csrf
            <x-form.group label="{{ __('Email') }}" for="email">
                <x-text-input id="email" type="email" name="email" :value="old('email')" required autofocus />
            </x-form.group>
            <div class="pt-1">
                <button class="btn btn-primary w-full justify-center">{{ __('Send Reset Link') }}</button>
            </div>
        </form>
    </div>
</x-guest-layout>
