<x-guest-layout>
    <div class="space-y-6">
        <div class="text-center">
            <h1 class="text-3xl font-extrabold tracking-tight">{{ __('Welcome Back') }}</h1>
            <p class="mt-2 text-sm text-muted">{{ __('Access your account to continue ordering.') }}</p>
        </div>
        <x-auth-session-status class="mb-2" :status="session('status')" />
        @if($errors->has('email'))
            <div class="rounded-md border border-amber-300/60 bg-amber-50 text-amber-900 dark:bg-amber-950/40 dark:text-amber-200 p-3 text-sm mb-2">
                {{ $errors->first('email') }}
            </div>
        @endif
        <form method="POST" action="{{ route('login') }}" class="form-stack">
            @csrf
            <x-form.group label="{{ __('Email') }}" for="email">
                <x-text-input id="email" type="email" name="email" :value="old('email')" required autofocus autocomplete="username" />
            </x-form.group>
            <x-form.group label="{{ __('Password') }}" for="password">
                <x-text-input id="password" type="password" name="password" required autocomplete="current-password" />
            </x-form.group>
            <div class="flex items-center justify-between pt-1">
                <label for="remember_me" class="inline-flex items-center gap-2 text-xs text-muted">
                    <input id="remember_me" type="checkbox" class="h-4 w-4 rounded border-subtle bg-transparent text-primary focus:ring-0" name="remember">
                    <span>{{ __('Remember me') }}</span>
                </label>
                @if (Route::has('password.request'))
                    <a class="text-xs font-medium text-primary hover:underline" href="{{ route('password.request') }}">{{ __('Forgot password?') }}</a>
                @endif
            </div>
            <div class="auth-actions">
                <button class="btn btn-primary w-full justify-center">{{ __('Log in') }}</button>
                <a href="{{ route('register') }}" class="btn btn-outline w-full justify-center">{{ __('Create account') }}</a>
            </div>
        </form>
    </div>
</x-guest-layout>
