<x-guest-layout>
    <div class="space-y-6">
        <div class="text-center">
            <h1 class="text-3xl font-extrabold tracking-tight">{{ __('Create Account') }}</h1>
            <p class="mt-2 text-sm text-muted">{{ __('Join us for quick ordering, tracking & address management.') }}</p>
        </div>
        <form method="POST" action="{{ route('register') }}" class="form-stack">
            @csrf
            @if($errors->has('email'))
                <div class="rounded-md border border-amber-300/60 bg-amber-50 text-amber-900 dark:bg-amber-950/40 dark:text-amber-200 p-3 text-sm mb-2">
                    {{ $errors->first('email') }}
                </div>
            @endif
            <div class="grid sm:grid-cols-2 gap-4">
                <x-form.group label="{{ __('First name') }}" for="first_name">
                    <x-text-input id="first_name" type="text" name="first_name" :value="old('first_name')" required autofocus />
                </x-form.group>
                <x-form.group label="{{ __('Last name') }}" for="last_name">
                    <x-text-input id="last_name" type="text" name="last_name" :value="old('last_name')" required />
                </x-form.group>
            </div>
            <div class="grid sm:grid-cols-2 gap-4">
                <x-form.group label="{{ __('Gender') }}" for="gender" :optional="true">
                    <select id="gender" name="gender" class="input">
                        <option value="">{{ __('Select gender (optional)') }}</option>
                        <option value="male" @selected(old('gender')==='male')>Male</option>
                        <option value="female" @selected(old('gender')==='female')>Female</option>
                    </select>
                </x-form.group>
                <x-form.group label="{{ __('Room number') }}" for="room_number" :optional="true">
                    <x-text-input id="room_number" type="text" name="room_number" :value="old('room_number')" />
                </x-form.group>
            </div>
            <x-form.group label="{{ __('Email') }}" for="email">
                <x-text-input id="email" type="email" name="email" :value="old('email')" required autocomplete="username" />
            </x-form.group>
            <x-form.group label="{{ __('Phone') }}" for="phone">
                <x-text-input id="phone" type="text" name="phone" :value="old('phone')" required autocomplete="tel" />
            </x-form.group>
            <div class="grid sm:grid-cols-2 gap-4">
                <x-form.group label="{{ __('Password') }}" for="password">
                    <x-text-input id="password" type="password" name="password" required autocomplete="new-password" />
                </x-form.group>
                <x-form.group label="{{ __('Confirm') }}" for="password_confirmation">
                    <x-text-input id="password_confirmation" type="password" name="password_confirmation" required autocomplete="new-password" />
                </x-form.group>
            </div>
            <div class="auth-actions">
                <a class="btn btn-outline w-full justify-center" href="{{ route('login') }}">{{ __('Already registered?') }}</a>
                <button class="btn btn-primary w-full justify-center">{{ __('Register') }}</button>
            </div>
        </form>
    </div>
</x-guest-layout>
