<x-guest-layout>
    <div class="space-y-6">
        <div class="text-center">
            <h1 class="text-3xl font-extrabold tracking-tight">{{ __('Choose New Password') }}</h1>
            <p class="mt-2 text-sm text-muted">{{ __('Use a strong unique password to protect your account.') }}</p>
        </div>
        <form method="POST" action="{{ route('password.store') }}" class="form-stack">
            @csrf
            @if($errors->has('email'))
                <div class="rounded-md border border-amber-300/60 bg-amber-50 text-amber-900 dark:bg-amber-950/40 dark:text-amber-200 p-3 text-sm mb-2">
                    {{ $errors->first('email') }}
                </div>
            @endif
            <input type="hidden" name="token" value="{{ $request->route('token') }}">
            <x-form.group label="{{ __('Email') }}" for="email">
                <x-text-input id="email" type="email" name="email" :value="old('email', $request->email)" required autofocus autocomplete="username" />
            </x-form.group>
            <x-form.group label="{{ __('Password') }}" for="password">
                <x-text-input id="password" type="password" name="password" required autocomplete="new-password" />
            </x-form.group>
            <x-form.group label="{{ __('Confirm Password') }}" for="password_confirmation">
                <x-text-input id="password_confirmation" type="password" name="password_confirmation" required autocomplete="new-password" />
            </x-form.group>
            <div class="pt-1">
                <button class="btn btn-primary w-full justify-center">{{ __('Reset Password') }}</button>
            </div>
        </form>
    </div>
</x-guest-layout>
