<x-guest-layout>
    <div class="space-y-6">
        <div class="text-center">
            <h1 class="text-3xl font-extrabold tracking-tight">{{ __('Verify your email') }}</h1>
            <p class="mt-2 text-sm text-muted">{{ __('We\'ve emailed you a verification link. Didn\'t receive it? Request a new one below.') }}</p>
        </div>
        @if (session('status') == 'verification-link-sent')
            <x-flash type="success" class="mb-2">{{ __('A new verification link has been sent.') }}</x-flash>
        @endif
        @if(session('status') && session('status') !== 'verification-link-sent')
            <div class="rounded-md border border-amber-300/60 bg-amber-50 text-amber-900 dark:bg-amber-950/40 dark:text-amber-200 p-3 text-sm mb-2">
                {{ session('status') }}
            </div>
        @endif
        <form method="POST" action="{{ route('verification.send') }}" class="form-stack">
            @csrf
            <button class="btn btn-primary w-full justify-center">{{ __('Resend Verification Email') }}</button>
        </form>
        <div class="form-stack">
            <a href="{{ route('logout.get') }}" class="btn btn-outline w-full justify-center text-xs">{{ __('Log Out') }}</a>
        </div>
    </div>
</x-guest-layout>
