<x-app-layout>
    <x-slot name="header">
        <h2 class="font-semibold text-xl text-gray-800 dark:text-gray-200 leading-tight">
            {{ __('Cart') }}
        </h2>
    </x-slot>

    <div class="py-6">
    <div class="container-px max-w-5xl">
            @if(empty($lines))
                <div class="surface rounded-xl p-6" data-aos="fade-up">
                    {{ __('Your cart is empty.') }}
                    <div class="mt-4">
                        <a href="{{ route('menu.index') }}" class="underline text-indigo-600">{{ __('Browse menu') }}</a>
                    </div>
                </div>
            @else
                <div class="surface rounded-xl" data-aos="fade-up">
                    <div class="p-6">
                        @if(!empty($belowMin) && $belowMin)
                            <x-flash type="warning" class="mb-4">Minimum order subtotal is ₦{{ number_format((float)$minSubtotal, 2) }}.</x-flash>
                        @endif
                        @if(!empty($atCapacity) && $atCapacity)
                            <x-flash type="error" class="mb-4">We are currently at capacity. You may experience longer prep times.</x-flash>
                        @endif
                        <div class="divide-y divide-gray-100/70 dark:divide-slate-700/50">
                            @foreach($lines as $line)
                                <div class="py-4 flex flex-wrap items-center gap-4 first:pt-0 last:pb-0">
                                    <div class="flex-1 min-w-[180px]">
                                        <div class="font-medium">{{ $line['dish']->name }}</div>
                                        <div class="text-xs text-muted">₦{{ number_format((float)$line['dish']->price, 2) }}</div>
                                    </div>
                                    <div class="flex items-center gap-2">
                                        <form method="POST" action="{{ route('cart.update') }}" class="flex items-center gap-2 cart-update-form">
                                            @csrf
                                            <input type="hidden" name="dish_id" value="{{ $line['dish']->id }}">
                                            <input type="number" name="quantity" value="{{ $line['qty'] }}" min="1" class="cart-qty w-20 h-9 text-center font-semibold rounded-md bg-slate-100 dark:bg-slate-800 text-slate-900 dark:text-slate-100 border border-slate-300 dark:border-slate-600 focus:outline-none focus:ring-2 focus:ring-indigo-500/50 focus:border-indigo-500 transition" aria-label="Quantity for {{ $line['dish']->name }}">
                                            <!-- Hidden fallback button (kept for non-JS users, visually removed) -->
                                            <button class="sr-only" aria-hidden="true" tabindex="-1">Update</button>
                                        </form>
                                        <form method="POST" action="{{ route('cart.remove') }}" title="Remove {{ $line['dish']->name }}">
                                            @csrf
                                            <input type="hidden" name="dish_id" value="{{ $line['dish']->id }}">
                                            <button type="submit" class="btn btn-danger h-9 py-1 text-xs flex items-center justify-center" aria-label="Remove {{ $line['dish']->name }}">
                                                <i data-lucide="trash-2" class="w-4 h-4"></i>
                                            </button>
                                        </form>
                                    </div>
                                    <div class="font-semibold ml-auto tabular-nums">₦{{ number_format((float)$line['lineTotal'], 2) }}</div>
                                </div>
                            @endforeach
                        </div>
                        <div class="mt-6 flex flex-col md:flex-row md:items-center md:justify-between gap-4">
                            <div class="text-lg font-semibold">{{ __('Subtotal') }}: <span data-cart-subtotal>₦{{ number_format((float)$subtotal, 2) }}</span></div>
                            <div class="flex items-center gap-2 flex-wrap">
                                <form method="POST" action="{{ route('cart.clear') }}">
                                    @csrf
                                    <button class="btn btn-outline h-10 text-sm"><i data-lucide="x-circle" class="w-4 h-4"></i>{{ __('Clear cart') }}</button>
                                </form>
                                <a href="{{ route('checkout.index') }}" class="btn btn-primary h-10 text-sm inline-flex items-center gap-2"><i data-lucide="badge-check" class="w-4 h-4"></i>{{ __('Checkout') }}</a>
                            </div>
                        </div>
                    </div>
                </div>
            @endif
        </div>
    </div>
</x-app-layout>
<x-customer.mobile-bar />

<script>
// Immediate execution (no reliance on stack ordering)
(function(){
    function ready(fn){ if(document.readyState !== 'loading') fn(); else document.addEventListener('DOMContentLoaded', fn); }
    ready(function(){
        // Provide minimal toast fallback if global wasn't yet defined
        if(typeof window.showToast !== 'function') {
            window.showToast = function(msg){ try { alert(msg); } catch(_) {} };
        }
        const forms = document.querySelectorAll('.cart-update-form');
        if(!forms.length) return;
        forms.forEach((form) => {
            const qty = form.querySelector('input[name="quantity"]');
            if(!qty) return;
            // Force JSON path so Controller returns JSON (ensures badge + toast update) even if intercept fails
            form.dataset.ajax = '1';
            let lastVal = qty.value;
            let debounce, busy = false;
            function submitAjax(){
                if(busy) return; busy = true;
                const fd = new FormData(form);
                // Manually send fetch instead of relying solely on footer hook in case it attaches late
                fetch(form.action, { method:'POST', headers:{'X-Requested-With':'XMLHttpRequest','X-CSRF-TOKEN':document.querySelector('meta[name="csrf-token"]').content}, body: fd })
                    .then(r=>r.json()).then(j=>{
                        // Trigger existing toast mechanism if available
                        if(window.showToast && j?.ok){ showToast('Cart updated'); }
                        const badge = document.getElementById('nav-cart-count');
                        if(badge && typeof j.count !== 'undefined') {
                            if(j.count>0){ badge.textContent=j.count; badge.classList.remove('hidden'); } else { badge.textContent='0'; badge.classList.add('hidden'); }
                        }
                        // Optimistic UI: recompute line total & subtotal if price metadata present in DOM
                        try {
                            const priceEl = form.parentElement?.previousElementSibling?.querySelector('.text-xs');
                            // Fallback: parse the price from sibling text content (₦X)
                            const priceText = priceEl ? priceEl.textContent : '';
                            const match = /₦\s*([0-9,]+(?:\.[0-9]{1,2})?)/.exec(priceText || '');
                            const unit = match ? parseFloat(match[1].replace(/,/g,'')) : null;
                            if(unit){
                                const qtyNow = parseInt(qty.value,10) || 1;
                                const lineEl = form.closest('.py-4')?.querySelector('.tabular-nums');
                                if(lineEl){
                                    const newLine = (unit * qtyNow).toLocaleString(undefined,{minimumFractionDigits:2, maximumFractionDigits:2});
                                    lineEl.textContent = '₦'+newLine;
                                }
                                // Re-sum subtotals
                                let sum = 0;
                                document.querySelectorAll('.tabular-nums').forEach(e=>{
                                    const m = /₦\s*([0-9,]+(?:\.[0-9]{1,2})?)/.exec(e.textContent||'');
                                    if(m) sum += parseFloat(m[1].replace(/,/g,''));
                                });
                                const subEl = document.querySelector('[data-cart-subtotal]');
                                if(subEl){
                                    subEl.textContent = '₦'+sum.toLocaleString(undefined,{minimumFractionDigits:2, maximumFractionDigits:2});
                                }
                            }
                        } catch(_) {}
                    }).catch(()=>{}).finally(()=>{ busy=false; });
            }
            function maybe(){
                const v = qty.value.trim();
                if(!v) return;
                const n = parseInt(v,10);
                if(isNaN(n) || n<1){ qty.value = 1; return; }
                if(String(n) === String(lastVal)) return;
                lastVal = n;
                submitAjax();
            }
            qty.addEventListener('change', maybe);
            qty.addEventListener('input', ()=>{ clearTimeout(debounce); debounce = setTimeout(maybe, 500); });
            qty.addEventListener('keydown', (e)=>{ if(e.key==='Enter'){ e.preventDefault(); maybe(); } });
        });
    });
})();
</script>
