<x-app-layout>
    <x-slot name="header">
        <h2 class="font-semibold text-xl text-gray-800 dark:text-gray-200 leading-tight">
            {{ __('Checkout') }}
        </h2>
    </x-slot>

    <div class="py-6">
        <div class="container-px max-w-3xl">
            <div class="surface rounded-xl overflow-hidden" data-aos="fade-up">
                <div class="p-6">
                    @isset($dbUnavailable)
                        @if($dbUnavailable)
                            <div class="mb-4 rounded-md border border-amber-300/60 bg-amber-50 text-amber-900 dark:bg-amber-950/40 dark:text-amber-200 p-3">
                                Ordering is temporarily unavailable due to maintenance. Please try again shortly.
                            </div>
                        @endif
                    @endisset
                    <form method="POST" action="{{ route('checkout.store') }}" class="space-y-4 checkout-form">
                        @csrf
                        @php($isGuest = auth()->user()->is_guest ?? false)
                        @if($isGuest)
                            <div>
                                <x-input-label for="delivery_mode" :value="__('Deliver to')" />
                                <x-select id="delivery_mode" name="delivery_mode" class="mt-1 w-full">
                                    <option value="room" {{ old('delivery_mode') === 'room' ? 'selected' : '' }}>My Room</option>
                                    <option value="external" {{ old('delivery_mode') === 'external' ? 'selected' : '' }}>Another Address</option>
                                </x-select>
                            </div>
                            <div id="room-info" class="mt-2">
                                <x-input-label for="room_number" :value="__('Room number')" />
                                <x-text-input id="room_number" name="room_number" type="text" class="mt-1 w-full" required
                                    value="{{ old('room_number', auth()->user()->room_number ?? '') }}"
                                    placeholder="e.g. 5 or 12A"
                                />
                                <x-input-error :messages="$errors->get('room_number')" class="mt-2" />
                            </div>
                            <div id="address-info" class="mt-2" style="display:none;">
                                <x-input-label for="delivery_address" :value="__('Delivery address')" />
                                <x-text-input id="delivery_address" name="delivery_address" type="text" class="mt-1 w-full"
                                    value="{{ old('delivery_address', '') }}"
                                    placeholder="e.g. 123 Main St"
                                />
                                <x-input-error :messages="$errors->get('delivery_address')" class="mt-2" />
                            </div>
                            <script>
                            document.addEventListener('DOMContentLoaded', function() {
                                var mode = document.getElementById('delivery_mode');
                                var roomInfo = document.getElementById('room-info');
                                var addressInfo = document.getElementById('address-info');
                                function updateFields() {
                                    if (mode.value === 'room') {
                                        roomInfo.style.display = '';
                                        addressInfo.style.display = 'none';
                                        document.getElementById('room_number').required = true;
                                        document.getElementById('delivery_address').required = false;
                                    } else {
                                        roomInfo.style.display = 'none';
                                        addressInfo.style.display = '';
                                        document.getElementById('room_number').required = false;
                                        document.getElementById('delivery_address').required = true;
                                    }
                                }
                                mode.addEventListener('change', updateFields);
                                updateFields();
                            });
                            </script>
                        @elseif(! $isGuest)
                            <div>
                                <x-input-label for="delivery_address" :value="__('Delivery address')" />
                                <x-text-input id="delivery_address" name="delivery_address" type="text" class="mt-1 w-full" required
                                    value="{{ old('delivery_address', '') }}"
                                    placeholder="e.g. 123 Main St"
                                />
                                <x-input-error :messages="$errors->get('delivery_address')" class="mt-2" />
                            </div>
                        @endif
                        <div>
                            <x-input-label for="payment_method" :value="__('Payment method')" />
                            <x-select id="payment_method" name="payment_method" class="mt-1" required>
                                @if(auth()->user()->is_guest && $roomServiceEnabled)
                                    <option value="Charge to Room">Charge to Room</option>
                                @endif
                                <option value="Cash on Delivery">Cash on Delivery</option>
                                <option value="Paystack">Pay with Paystack</option>
                            </x-select>
                            <x-input-error :messages="$errors->get('payment_method')" class="mt-2" />
                        </div>
                        @php($psSecret = config('services.paystack.secret') ?? env('PAYSTACK_SECRET'))
                        @if(\Illuminate\Support\Str::startsWith((string)$psSecret, 'sk_test'))
                            <x-flash type="info" class="mt-2">
                                <div class="font-semibold mb-1">Paystack Test Mode</div>
                                <div>Use these test cards to simulate payments:</div>
                                <ul class="list-disc ms-5 mt-1">
                                    <li>PIN + OTP: 5060 6666 6666 6666 666, Exp: any future, CVV: 123, PIN: 1234, OTP: 123456</li>
                                    <li>PIN validation: 5078 5078 5078 5078 12, Exp: any future, CVV: 081, PIN: 1111</li>
                                    <li>No validation (reusable): 4084 0840 8408 4081, Exp: any future, CVV: 408</li>
                                    <li>Simulate decline: 4084 0800 0000 5408 (CVV 001)</li>
                                </ul>
                                <div class="mt-1">This notice only appears with test keys.</div>
                            </x-flash>
                        @endif
                        <div>
                            <x-input-label for="tip" :value="__('Tip (optional) in ₦)')" />
                            <x-text-input id="tip" name="tip" type="number" step="0.01" min="0" class="mt-1 w-full" value="{{ old('tip', '0') }}" placeholder="0" />
                            <x-input-error :messages="$errors->get('tip')" class="mt-2" />
                        </div>
                        <div class="space-y-1 text-sm">
                            <div class="flex items-center gap-2"><i data-lucide="wallet" class="w-4 h-4 text-slate-500"></i>{{ __('Subtotal') }}: ₦{{ number_format((float)$subtotal, 2) }}</div>
                            <div class="flex items-center gap-2"><i data-lucide="truck" class="w-4 h-4 text-slate-500"></i>{{ __('Delivery fee') }}: ₦{{ number_format((float)$delivery, 2) }}</div>
                            <div class="flex items-center gap-2"><i data-lucide="percent" class="w-4 h-4 text-slate-500"></i>{{ __('Service charge') }}: ₦{{ number_format((float)($service ?? 0), 2) }}</div>
                            <div class="flex items-center gap-2"><i data-lucide="gift" class="w-4 h-4 text-slate-500"></i>{{ __('Guest discount') }}: -₦{{ number_format((float)$discount, 2) }}</div>
                            <div class="text-lg font-semibold flex items-center gap-2"><i data-lucide="badge-check" class="w-5 h-5 text-emerald-500"></i>{{ __('Total') }}: ₦{{ number_format((float)$total, 2) }}</div>
                        </div>
                        @if(!empty($belowMin) && $belowMin)
                            <x-flash type="warning">Minimum order subtotal is ₦{{ number_format((float)$minSubtotal, 2) }}.</x-flash>
                        @endif
                        @if(!empty($atCapacity) && $atCapacity)
                            <x-flash type="error">We are currently at capacity. You may experience longer prep times.</x-flash>
                        @endif
                        <div class="flex items-center justify-end">
                            <button class="btn btn-primary inline-flex items-center gap-2 {{ !empty($dbUnavailable) && $dbUnavailable ? 'pointer-events-none opacity-60' : '' }}" {{ (!empty($dbUnavailable) && $dbUnavailable) ? 'disabled' : '' }}><i data-lucide="chef-hat" class="w-4 h-4"></i>{{ __('Place order') }}</button>
                        </div>
                        @error('checkout')
                            <div class="text-red-600 text-sm">{{ $message }}</div>
                        @enderror
                    </form>
                </div>
            </div>
        </div>
    </div>
</x-app-layout>
